/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.threading;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.threading.ConfigThreadPool;
import com.seibel.distanthorizons.core.util.threading.DhThreadFactory;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class ThreadPools {
    public static final DhThreadFactory FILE_HANDLER_THREAD_FACTORY = new DhThreadFactory("File Handler", 1);
    private static ConfigThreadPool fileHandlerThreadPool;
    public static final DhThreadFactory WORLD_GEN_THREAD_FACTORY;
    private static ConfigThreadPool worldGenThreadPool;
    private static ThreadPoolExecutor bufferUploaderThreadPool;
    public static final DhThreadFactory LIGHT_POPULATOR_THREAD_FACTORY;
    private static ConfigThreadPool lightPopulatorThreadPool;
    public static final DhThreadFactory CHUNK_TO_LOD_BUILDER_THREAD_FACTORY;
    private static ConfigThreadPool chunkToLodBuilderThreadPool;
    public static final DhThreadFactory BUFFER_BUILDER_THREAD_FACTORY;
    private static ConfigThreadPool bufferBuilderThreadPool;
    private static int workerThreadSemaphoreCount;
    private static Semaphore workerThreadSemaphore;
    private static ConfigChangeListener<Integer> workerThreadSemaphoreConfigListener;

    @Nullable
    public static ThreadPoolExecutor getFileHandlerExecutor() {
        return ThreadPools.fileHandlerThreadPool.executor;
    }

    @Nullable
    public static ThreadPoolExecutor getWorldGenExecutor() {
        return ThreadPools.worldGenThreadPool.executor;
    }

    @Nullable
    public static ThreadPoolExecutor getBufferUploaderExecutor() {
        return bufferUploaderThreadPool;
    }

    @Nullable
    public static ThreadPoolExecutor getLightPopulatorExecutor() {
        return ThreadPools.lightPopulatorThreadPool.executor;
    }

    @Nullable
    public static ThreadPoolExecutor getChunkToLodBuilderExecutor() {
        return ThreadPools.chunkToLodBuilderThreadPool.executor;
    }

    @Nullable
    public static ThreadPoolExecutor getBufferBuilderExecutor() {
        return ThreadPools.bufferBuilderThreadPool.executor;
    }

    public static int getWorkerThreadCount() {
        return workerThreadSemaphoreCount;
    }

    public static void setupThreadPools() {
        fileHandlerThreadPool = new ConfigThreadPool(FILE_HANDLER_THREAD_FACTORY, Config.Client.Advanced.MultiThreading.numberOfFileHandlerThreads, Config.Client.Advanced.MultiThreading.runTimeRatioForFileHandlerThreads, null);
        worldGenThreadPool = new ConfigThreadPool(WORLD_GEN_THREAD_FACTORY, Config.Client.Advanced.MultiThreading.numberOfWorldGenerationThreads, Config.Client.Advanced.MultiThreading.runTimeRatioForWorldGenerationThreads, null);
        bufferUploaderThreadPool = ThreadUtil.makeSingleThreadPool("Buffer Uploader");
        if (Config.Client.Advanced.MultiThreading.enableLodBuilderThreadLimiting.get().booleanValue()) {
            workerThreadSemaphoreCount = Config.Client.Advanced.MultiThreading.numberOfLodBuilderThreads.get();
            workerThreadSemaphore = new Semaphore(workerThreadSemaphoreCount);
            workerThreadSemaphoreConfigListener = new ConfigChangeListener<Integer>(Config.Client.Advanced.MultiThreading.numberOfLodBuilderThreads, val -> {
                int changePermit = val - workerThreadSemaphoreCount;
                if (changePermit > 0) {
                    workerThreadSemaphore.release(changePermit);
                } else {
                    workerThreadSemaphore.acquireUninterruptibly(changePermit * -1);
                }
                workerThreadSemaphoreCount += changePermit;
            });
        }
        lightPopulatorThreadPool = new ConfigThreadPool(LIGHT_POPULATOR_THREAD_FACTORY, Config.Client.Advanced.MultiThreading.numberOfLodBuilderThreads, Config.Client.Advanced.MultiThreading.runTimeRatioForLodBuilderThreads, workerThreadSemaphore);
        chunkToLodBuilderThreadPool = new ConfigThreadPool(CHUNK_TO_LOD_BUILDER_THREAD_FACTORY, Config.Client.Advanced.MultiThreading.numberOfLodBuilderThreads, Config.Client.Advanced.MultiThreading.runTimeRatioForLodBuilderThreads, workerThreadSemaphore);
        bufferBuilderThreadPool = new ConfigThreadPool(BUFFER_BUILDER_THREAD_FACTORY, Config.Client.Advanced.MultiThreading.numberOfLodBuilderThreads, Config.Client.Advanced.MultiThreading.runTimeRatioForLodBuilderThreads, workerThreadSemaphore);
    }

    public static void shutdownThreadPools() {
        fileHandlerThreadPool.shutdownExecutorService();
        worldGenThreadPool.shutdownExecutorService();
        bufferUploaderThreadPool.shutdown();
        lightPopulatorThreadPool.shutdownExecutorService();
        chunkToLodBuilderThreadPool.shutdownExecutorService();
        bufferBuilderThreadPool.shutdownExecutorService();
        workerThreadSemaphore = null;
        if (workerThreadSemaphoreConfigListener != null) {
            workerThreadSemaphoreConfigListener.close();
            workerThreadSemaphoreConfigListener = null;
        }
    }

    static {
        WORLD_GEN_THREAD_FACTORY = new DhThreadFactory("World Gen", 1);
        LIGHT_POPULATOR_THREAD_FACTORY = new DhThreadFactory("LOD Builder - Light Populator", 1);
        CHUNK_TO_LOD_BUILDER_THREAD_FACTORY = new DhThreadFactory("LOD Builder - Chunk to Lod Builder", 1);
        BUFFER_BUILDER_THREAD_FACTORY = new DhThreadFactory("LOD Builder - Buffer Builder", 1);
        workerThreadSemaphoreCount = Config.Client.Advanced.MultiThreading.numberOfLodBuilderThreads.get();
        workerThreadSemaphore = null;
        workerThreadSemaphoreConfigListener = null;
    }
}

