/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects.quadTree.iterators;

import com.seibel.distanthorizons.core.util.objects.quadTree.QuadNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Consumer;

public class QuadTreeNodeIterator<T>
implements Iterator<QuadNode<T>> {
    private final byte highestDetailLevel;
    private final Queue<QuadNode<T>> validNodesForDetailLevel = new LinkedList<QuadNode<T>>();
    private final Queue<QuadNode<T>> iteratorNodeQueue = new LinkedList<QuadNode<T>>();
    private byte iteratorDetailLevel = 0;
    private final boolean onlyReturnLeafValues;

    public QuadTreeNodeIterator(QuadNode<T> rootNode, boolean onlyReturnLeafValues) {
        this.onlyReturnLeafValues = onlyReturnLeafValues;
        this.highestDetailLevel = rootNode.minimumDetailLevel;
        this.iteratorDetailLevel = rootNode.sectionPos.getDetailLevel();
        if (!this.onlyReturnLeafValues) {
            this.validNodesForDetailLevel.add(rootNode);
            this.iteratorNodeQueue.add(rootNode);
        } else {
            LinkedList parentNodeQueue = new LinkedList();
            parentNodeQueue.add(rootNode);
            while (parentNodeQueue.peek() != null) {
                QuadNode parentNode = (QuadNode)parentNodeQueue.poll();
                for (int i = 0; i < 4; ++i) {
                    QuadNode childNode = parentNode.getChildByIndex(i);
                    if (childNode == null) continue;
                    if (childNode.getTotalChildCount() == 0) {
                        this.iteratorNodeQueue.add(childNode);
                        continue;
                    }
                    parentNodeQueue.add(childNode);
                }
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.iteratorNodeQueue.size() != 0;
    }

    @Override
    public QuadNode<T> next() {
        if (this.iteratorDetailLevel < this.highestDetailLevel) {
            throw new NoSuchElementException("Highest detail level reached [" + this.highestDetailLevel + "].");
        }
        if (this.iteratorNodeQueue.size() == 0) {
            throw new NoSuchElementException();
        }
        QuadNode<T> currentNode = this.iteratorNodeQueue.poll();
        if (this.iteratorNodeQueue.size() == 0 && !this.onlyReturnLeafValues) {
            this.iteratorDetailLevel = (byte)(this.iteratorDetailLevel - 1);
            if (this.iteratorDetailLevel >= this.highestDetailLevel) {
                LinkedList<QuadNode<T>> parentNodes = new LinkedList<QuadNode<T>>(this.validNodesForDetailLevel);
                this.validNodesForDetailLevel.clear();
                for (QuadNode quadNode : parentNodes) {
                    for (int i = 0; i < 4; ++i) {
                        QuadNode childNode = quadNode.getChildByIndex(i);
                        if (childNode == null) continue;
                        this.iteratorNodeQueue.add(childNode);
                        this.validNodesForDetailLevel.add(childNode);
                    }
                }
            }
        }
        return currentNode;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void forEachRemaining(Consumer<? super QuadNode<T>> action) {
        Iterator.super.forEachRemaining(action);
    }
}

