/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects.quadTree;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.objects.quadTree.iterators.QuadNodeDirectChildIterator;
import com.seibel.distanthorizons.core.util.objects.quadTree.iterators.QuadNodeDirectChildPosIterator;
import com.seibel.distanthorizons.core.util.objects.quadTree.iterators.QuadTreeNodeIterator;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;

public class QuadNode<T> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final DhSectionPos sectionPos;
    public final byte minimumDetailLevel;
    public T value;
    public QuadNode<T> nwChild;
    public QuadNode<T> neChild;
    public QuadNode<T> swChild;
    public QuadNode<T> seChild;

    public QuadNode(DhSectionPos sectionPos, byte minimumDetailLevel) {
        this.sectionPos = sectionPos;
        this.minimumDetailLevel = minimumDetailLevel;
    }

    public int getTotalChildCount() {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.getChildByIndex(i) == null) continue;
            ++count;
        }
        return count;
    }

    public int getNonNullChildCount() {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            QuadNode<T> child = this.getChildByIndex(i);
            if (child == null || child.value == null && child.getNonNullChildCount() == 0) continue;
            ++count;
        }
        return count;
    }

    public QuadNode<T> getChildByIndex(int child0to3) throws IllegalArgumentException {
        switch (child0to3) {
            case 0: {
                return this.nwChild;
            }
            case 1: {
                return this.swChild;
            }
            case 2: {
                return this.neChild;
            }
            case 3: {
                return this.seChild;
            }
        }
        throw new IllegalArgumentException("child0to3 must be between 0 and 3");
    }

    public QuadNode<T> getNode(DhSectionPos sectionPos) throws IllegalArgumentException {
        return this.getOrSetValue(sectionPos, false, null);
    }

    public T setValue(DhSectionPos sectionPos, T newValue) throws IllegalArgumentException {
        QuadNode<T> previousNode = this.getNode(sectionPos);
        if (previousNode != null) {
            T previousValue = previousNode.value;
            previousNode.value = newValue;
            return previousValue;
        }
        this.getOrSetValue(sectionPos, true, newValue);
        return null;
    }

    private QuadNode<T> getOrSetValue(DhSectionPos inputSectionPos, boolean replaceValue, T newValue) throws IllegalArgumentException {
        if (!this.sectionPos.contains(inputSectionPos)) {
            LOGGER.error((replaceValue ? "set " : "get ") + inputSectionPos + " center block: " + inputSectionPos.getCenterBlockPos() + ", this pos: " + this.sectionPos + " this center block: " + this.sectionPos.getCenterBlockPos());
            throw new IllegalArgumentException("Input section pos " + inputSectionPos + " outside of this quadNode's pos: " + this.sectionPos + ", this node's blockPos: " + this.sectionPos.convertNewToDetailLevel((byte)0) + " block width: " + this.sectionPos.getBlockWidth() + " input detail level: " + inputSectionPos.convertNewToDetailLevel((byte)0) + " width: " + inputSectionPos.getBlockWidth());
        }
        if (inputSectionPos.getDetailLevel() > this.sectionPos.getDetailLevel()) {
            throw new IllegalArgumentException("detail level higher than this node. Node Detail level: " + this.sectionPos.getDetailLevel() + " input detail level: " + inputSectionPos.getDetailLevel());
        }
        if (inputSectionPos.getDetailLevel() == this.sectionPos.getDetailLevel() && !inputSectionPos.equals(this.sectionPos)) {
            throw new IllegalArgumentException("Node and input detail level are equal, however positions are not; this tree doesn't contain the requested position. Node pos: " + this.sectionPos + ", input pos: " + inputSectionPos);
        }
        if (inputSectionPos.getDetailLevel() < this.minimumDetailLevel) {
            throw new IllegalArgumentException("Input position is requesting a detail level lower than what this node can provide. Node minimum detail level: " + this.minimumDetailLevel + ", input pos: " + inputSectionPos);
        }
        if (inputSectionPos.getDetailLevel() == this.sectionPos.getDetailLevel()) {
            if (replaceValue) {
                this.value = newValue;
            }
            return this;
        }
        DhSectionPos nwPos = this.sectionPos.getChildByIndex(0);
        DhSectionPos swPos = this.sectionPos.getChildByIndex(1);
        DhSectionPos nePos = this.sectionPos.getChildByIndex(2);
        DhSectionPos sePos = this.sectionPos.getChildByIndex(3);
        if (nwPos.contains(inputSectionPos)) {
            QuadNode<T> childNode;
            if (replaceValue && this.nwChild == null) {
                this.nwChild = new QuadNode<T>(nwPos, this.minimumDetailLevel);
            }
            return (childNode = this.nwChild) != null ? super.getOrSetValue(inputSectionPos, replaceValue, newValue) : null;
        }
        if (swPos.contains(inputSectionPos)) {
            QuadNode<T> childNode;
            if (replaceValue && this.swChild == null) {
                this.swChild = new QuadNode<T>(swPos, this.minimumDetailLevel);
            }
            return (childNode = this.swChild) != null ? super.getOrSetValue(inputSectionPos, replaceValue, newValue) : null;
        }
        if (nePos.contains(inputSectionPos)) {
            QuadNode<T> childNode;
            if (replaceValue && this.neChild == null) {
                this.neChild = new QuadNode<T>(nePos, this.minimumDetailLevel);
            }
            return (childNode = this.neChild) != null ? super.getOrSetValue(inputSectionPos, replaceValue, newValue) : null;
        }
        if (sePos.contains(inputSectionPos)) {
            QuadNode<T> childNode;
            if (replaceValue && this.seChild == null) {
                this.seChild = new QuadNode<T>(sePos, this.minimumDetailLevel);
            }
            return (childNode = this.seChild) != null ? super.getOrSetValue(inputSectionPos, replaceValue, newValue) : null;
        }
        throw new IllegalStateException("input position not contained by any node children. This should've been caught by the this.sectionPos.contains(inputPos) assert before this point.");
    }

    public Iterator<QuadNode<T>> getNodeIterator() {
        return new QuadTreeNodeIterator(this, false);
    }

    public Iterator<QuadNode<T>> getLeafNodeIterator() {
        return new QuadTreeNodeIterator(this, true);
    }

    public Iterator<DhSectionPos> getChildPosIterator() {
        return new QuadNodeDirectChildPosIterator(this);
    }

    public Iterator<QuadNode<T>> getChildNodeIterator() {
        return new QuadNodeDirectChildIterator(this);
    }

    public void deleteAllChildren() {
        this.deleteAllChildren(null);
    }

    public void deleteAllChildren(Consumer<? super T> removedItemConsumer) {
        for (int i = 0; i < 4; ++i) {
            QuadNode<? super T> childNode = this.getChildByIndex(i);
            if (childNode == null) continue;
            childNode.deleteAllChildren(removedItemConsumer);
        }
        if (this.nwChild != null && removedItemConsumer != null) {
            removedItemConsumer.accept(this.nwChild.value);
        }
        this.nwChild = null;
        if (this.neChild != null && removedItemConsumer != null) {
            removedItemConsumer.accept(this.neChild.value);
        }
        this.neChild = null;
        if (this.seChild != null && removedItemConsumer != null) {
            removedItemConsumer.accept(this.seChild.value);
        }
        this.seChild = null;
        if (this.swChild != null && removedItemConsumer != null) {
            removedItemConsumer.accept(this.swChild.value);
        }
        this.swChild = null;
    }

    public String toString() {
        return "pos: " + this.sectionPos + ", children #: " + this.getTotalChildCount() + ", value: " + this.value;
    }
}

