/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.IColumnDataView;
import com.seibel.distanthorizons.core.logging.SpamReducedLogger;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import java.util.Arrays;

public class RenderDataPointUtil {
    private static final SpamReducedLogger warnLogger = new SpamReducedLogger(1);
    public static final int EMPTY_DATA = 0;
    public static final int MAX_WORLD_Y_SIZE = 4096;
    public static final int ALPHA_DOWNSIZE_SHIFT = 4;
    public static final int GEN_TYPE_SHIFT = 60;
    public static final int COLOR_SHIFT = 32;
    public static final int BLUE_SHIFT = 32;
    public static final int GREEN_SHIFT = 40;
    public static final int RED_SHIFT = 48;
    public static final int ALPHA_SHIFT = 56;
    public static final int HEIGHT_SHIFT = 20;
    public static final int DEPTH_SHIFT = 8;
    public static final int BLOCK_LIGHT_SHIFT = 4;
    public static final int SKY_LIGHT_SHIFT = 0;
    public static final long ALPHA_MASK = 15L;
    public static final long RED_MASK = 255L;
    public static final long GREEN_MASK = 255L;
    public static final long BLUE_MASK = 255L;
    public static final long COLOR_MASK = 0xFFFFFFL;
    public static final long HEIGHT_MASK = 4095L;
    public static final long DEPTH_MASK = 4095L;
    public static final long HEIGHT_DEPTH_MASK = 0xFFFFFFL;
    public static final long BLOCK_LIGHT_MASK = 15L;
    public static final long SKY_LIGHT_MASK = 15L;
    public static final long GEN_TYPE_MASK = 7L;
    public static final long COMPARE_SHIFT = 60L;
    public static final long HEIGHT_SHIFTED_MASK = 0xFFF00000L;
    public static final long DEPTH_SHIFTED_MASK = 1048320L;
    public static final long GEN_TYPE_SHIFTED_MASK = 0x7000000000000000L;
    public static final long VOID_SETTER = 0xFFFFFF00L;
    private static final ThreadLocal<int[]> tLocalIndices = new ThreadLocal();
    private static final ThreadLocal<boolean[]> tLocalIncreaseIndex = new ThreadLocal();
    private static final ThreadLocal<boolean[]> tLocalIndexHandled = new ThreadLocal();
    private static final ThreadLocal<short[]> tLocalHeightAndDepth = new ThreadLocal();
    private static final ThreadLocal<int[]> tDataIndexCache = new ThreadLocal();

    public static long createVoidDataPoint(byte generationMode) {
        if (generationMode == 0) {
            throw new IllegalArgumentException("Trying to create void datapoint with genMode 0, which is NOT allowed in DataPoint version 10!");
        }
        return ((long)generationMode & 7L) << 60;
    }

    public static long createDataPoint(int height, int depth, int color, int lightSky, int lightBlock, int generationMode) {
        return RenderDataPointUtil.createDataPoint(ColorUtil.getAlpha(color), ColorUtil.getRed(color), ColorUtil.getGreen(color), ColorUtil.getBlue(color), height, depth, lightSky, lightBlock, generationMode);
    }

    public static long createDataPoint(int height, int depth, int color, int light, int generationMode) {
        LodUtil.assertTrue(light >= 0 && light < 256, "Raw Light value must be between 0 and 255!");
        return RenderDataPointUtil.createDataPoint(ColorUtil.getAlpha(color), ColorUtil.getRed(color), ColorUtil.getGreen(color), ColorUtil.getBlue(color), height, depth, light % 16, light / 16, generationMode);
    }

    public static long createDataPoint(int alpha, int red, int green, int blue, int height, int depth, int lightSky, int lightBlock, int generationMode) {
        LodUtil.assertTrue(generationMode != 0, "Trying to create datapoint with genMode 0, which is NOT allowed in DataPoint version 10!");
        LodUtil.assertTrue(height >= 0 && height < 4096, "Trying to create datapoint with height[" + height + "] out of range!");
        LodUtil.assertTrue(depth >= 0 && depth < 4096, "Trying to create datapoint with depth[" + depth + "] out of range!");
        LodUtil.assertTrue(lightSky >= 0 && lightSky < 16, "Trying to create datapoint with lightSky[" + lightSky + "] out of range!");
        LodUtil.assertTrue(lightBlock >= 0 && lightBlock < 16, "Trying to create datapoint with lightBlock[" + lightBlock + "] out of range!");
        LodUtil.assertTrue(alpha >= 0 && alpha < 256, "Trying to create datapoint with alpha[" + alpha + "] out of range!");
        LodUtil.assertTrue(red >= 0 && red < 256, "Trying to create datapoint with red[" + red + "] out of range!");
        LodUtil.assertTrue(green >= 0 && green < 256, "Trying to create datapoint with green[" + green + "] out of range!");
        LodUtil.assertTrue(blue >= 0 && blue < 256, "Trying to create datapoint with blue[" + blue + "] out of range!");
        LodUtil.assertTrue(generationMode >= 0 && generationMode < 8, "Trying to create datapoint with genMode[" + generationMode + "] out of range!");
        LodUtil.assertTrue(depth <= height, "Trying to create datapoint with depth[" + depth + "] greater than height[" + height + "]!");
        return (long)(alpha >>> 4) << 56 | ((long)red & 0xFFL) << 48 | ((long)green & 0xFFL) << 40 | ((long)blue & 0xFFL) << 32 | ((long)height & 0xFFFL) << 20 | ((long)depth & 0xFFFL) << 8 | ((long)lightBlock & 0xFL) << 4 | ((long)lightSky & 0xFL) << 0 | ((long)generationMode & 7L) << 60;
    }

    public static long shiftHeightAndDepth(long dataPoint, short offset) {
        long height = dataPoint + ((long)offset << 20) & 0xFFF00000L;
        long depth = dataPoint + (long)(offset << 8) & 0xFFF00L;
        return dataPoint & 0xFFFFFFFF000000FFL | height | depth;
    }

    public static short getYMax(long dataPoint) {
        return (short)(dataPoint >>> 20 & 0xFFFL);
    }

    public static short getYMin(long dataPoint) {
        return (short)(dataPoint >>> 8 & 0xFFFL);
    }

    public static short getAlpha(long dataPoint) {
        return (short)((dataPoint >>> 56 & 0xFL) << 4 | 0xFL);
    }

    public static short getRed(long dataPoint) {
        return (short)(dataPoint >>> 48 & 0xFFL);
    }

    public static short getGreen(long dataPoint) {
        return (short)(dataPoint >>> 40 & 0xFFL);
    }

    public static short getBlue(long dataPoint) {
        return (short)(dataPoint >>> 32 & 0xFFL);
    }

    public static byte getLightSky(long dataPoint) {
        return (byte)(dataPoint >>> 0 & 0xFL);
    }

    public static byte getLightBlock(long dataPoint) {
        return (byte)(dataPoint >>> 4 & 0xFL);
    }

    public static byte getGenerationMode(long dataPoint) {
        byte genMode = (byte)(dataPoint >>> 60 & 7L);
        if (warnLogger.canMaybeLog() && RenderDataPointUtil.doesDataPointExist(dataPoint) && genMode == 0) {
            warnLogger.warnInc("Existing datapoint with genMode 0 detected! This is invalid in DataPoint version 10! This may be caused by old data that has not been updated correctly.", new Object[0]);
            return 1;
        }
        return genMode == 0 ? (byte)1 : genMode;
    }

    public static long overrideGenerationMode(long current, byte b) {
        return current & 0x8FFFFFFFFFFFFFFFL | ((long)b & 7L) << 60;
    }

    public static boolean isVoid(long dataPoint) {
        return (dataPoint >>> 8 & 0xFFFFFFL) == 0L;
    }

    public static boolean doesDataPointExist(long dataPoint) {
        return dataPoint != 0L;
    }

    public static int getColor(long dataPoint) {
        long alpha = RenderDataPointUtil.getAlpha(dataPoint);
        return (int)(dataPoint >>> 32 & 0xFFFFFFL | alpha << 24);
    }

    public static int compareDatapointPriority(long dataA, long dataB) {
        return (int)((dataA >> 60) - (dataB >> 60));
    }

    public static String toString(long dataPoint) {
        if (!RenderDataPointUtil.doesDataPointExist(dataPoint)) {
            return "null";
        }
        if (RenderDataPointUtil.isVoid(dataPoint)) {
            return "void";
        }
        return "Y+:" + RenderDataPointUtil.getYMax(dataPoint) + " Y-:" + RenderDataPointUtil.getYMin(dataPoint) + " argb:" + RenderDataPointUtil.getAlpha(dataPoint) + " " + RenderDataPointUtil.getRed(dataPoint) + " " + RenderDataPointUtil.getBlue(dataPoint) + " " + RenderDataPointUtil.getGreen(dataPoint) + " BL:" + RenderDataPointUtil.getLightBlock(dataPoint) + " SL:" + RenderDataPointUtil.getLightSky(dataPoint) + " G:" + RenderDataPointUtil.getGenerationMode(dataPoint);
    }

    public static void mergeMultiData(IColumnDataView sourceData, ColumnArrayView output) {
        long tempData;
        boolean[] indexHandled;
        byte genMode;
        if (output.dataCount() != 1) {
            throw new IllegalArgumentException("output must be only reserved for one datapoint!");
        }
        int inputVerticalSize = sourceData.verticalSize();
        int outputVerticalSize = output.verticalSize();
        output.fill(0L);
        int dataCount = sourceData.dataCount();
        int heightAndDepthLength = 4128;
        short[] heightAndDepth = tLocalHeightAndDepth.get();
        if (heightAndDepth == null || heightAndDepth.length != heightAndDepthLength) {
            heightAndDepth = new short[heightAndDepthLength];
            tLocalHeightAndDepth.set(heightAndDepth);
        }
        if ((genMode = RenderDataPointUtil.getGenerationMode(sourceData.get(0))) == 0) {
            genMode = 1;
        }
        boolean allEmpty = true;
        boolean allVoid = true;
        boolean limited = false;
        int count = 0;
        int[] indices = tLocalIndices.get();
        if (indices == null || indices.length != dataCount) {
            indices = new int[dataCount];
            tLocalIndices.set(indices);
        }
        Arrays.fill(indices, 0);
        boolean[] increaseIndex = tLocalIncreaseIndex.get();
        if (increaseIndex == null || increaseIndex.length != dataCount) {
            increaseIndex = new boolean[dataCount];
            tLocalIncreaseIndex.set(increaseIndex);
        }
        if ((indexHandled = tLocalIndexHandled.get()) == null || indexHandled.length != dataCount) {
            indexHandled = new boolean[dataCount];
            tLocalIndexHandled.set(indexHandled);
        }
        for (int index = 0; index < dataCount; ++index) {
            tempData = sourceData.get(index * inputVerticalSize);
            allVoid = allVoid && RenderDataPointUtil.isVoid(tempData);
            allEmpty = allEmpty && !RenderDataPointUtil.doesDataPointExist(tempData);
        }
        if (allEmpty) {
            return;
        }
        if (allVoid) {
            output.set(0, RenderDataPointUtil.createVoidDataPoint(genMode));
            return;
        }
        boolean stillHasDataToCheck = true;
        while (stillHasDataToCheck) {
            int index;
            Arrays.fill(indexHandled, false);
            boolean connected = true;
            short newHeight = -10000;
            short newDepth = -10000;
            while (connected) {
                Arrays.fill(increaseIndex, false);
                for (index = 0; index < dataCount; ++index) {
                    if (indices[index] >= inputVerticalSize) continue;
                    tempData = sourceData.get(index * inputVerticalSize + indices[index]);
                    if (!RenderDataPointUtil.isVoid(tempData) && RenderDataPointUtil.doesDataPointExist(tempData)) {
                        short tempYMax = RenderDataPointUtil.getYMax(tempData);
                        short tempYMin = RenderDataPointUtil.getYMin(tempData);
                        if (tempYMin >= newHeight) {
                            newDepth = tempYMin;
                            newHeight = tempYMax;
                            Arrays.fill(increaseIndex, false);
                            Arrays.fill(indexHandled, false);
                            increaseIndex[index] = true;
                            indexHandled[index] = true;
                            continue;
                        }
                        if (tempYMin >= newDepth && tempYMax <= newHeight) {
                            increaseIndex[index] = true;
                            indexHandled[index] = true;
                            continue;
                        }
                        if (tempYMax > newHeight && tempYMin <= newDepth) {
                            newDepth = tempYMin;
                            newHeight = tempYMax;
                            increaseIndex[index] = true;
                            indexHandled[index] = true;
                            continue;
                        }
                        if (tempYMax > newDepth && tempYMax <= newHeight) {
                            if (indexHandled[index]) continue;
                            newDepth = tempYMin;
                            increaseIndex[index] = true;
                            indexHandled[index] = true;
                            continue;
                        }
                        if (tempYMin >= newHeight || tempYMin <= newDepth) continue;
                        newHeight = tempYMax;
                        increaseIndex[index] = true;
                        continue;
                    }
                    indexHandled[index] = true;
                }
                connected = false;
                for (index = 0; index < dataCount; ++index) {
                    if (!increaseIndex[index]) continue;
                    connected = true;
                    int n = index;
                    indices[n] = indices[n] + 1;
                }
            }
            if (newDepth != newHeight) {
                short prevDepth;
                if (count != 0 && newHeight > (prevDepth = heightAndDepth[(count - 1) * 2 + 1])) {
                    newHeight = (short)Math.min(newHeight, prevDepth);
                }
                heightAndDepth[count * 2] = newHeight;
                heightAndDepth[count * 2 + 1] = newDepth;
                ++count;
            }
            stillHasDataToCheck = false;
            for (index = 0; index < dataCount; ++index) {
                if (indices[index] >= inputVerticalSize) continue;
                tempData = sourceData.get(index * inputVerticalSize + indices[index]);
                stillHasDataToCheck |= !RenderDataPointUtil.isVoid(tempData) && RenderDataPointUtil.doesDataPointExist(tempData);
            }
        }
        int j = 0;
        while (count > outputVerticalSize) {
            int i;
            limited = true;
            int ii = 4096;
            for (i = 0; i < count - 1; ++i) {
                if (heightAndDepth[i * 2 + 1] - heightAndDepth[(i + 1) * 2] > ii) continue;
                ii = heightAndDepth[i * 2 + 1] - heightAndDepth[(i + 1) * 2];
                j = i;
            }
            heightAndDepth[j * 2 + 1] = heightAndDepth[(j + 1) * 2 + 1];
            for (i = j + 1; i < count - 1; ++i) {
                heightAndDepth[i * 2] = heightAndDepth[(i + 1) * 2];
                heightAndDepth[i * 2 + 1] = heightAndDepth[(i + 1) * 2 + 1];
            }
            --count;
        }
        if (!limited && dataCount == 1) {
            sourceData.copyTo(output.data, output.offset, output.vertSize);
        } else {
            int[] dataIndexesCache = tDataIndexCache.get();
            if (dataIndexesCache == null || dataIndexesCache.length != dataCount) {
                dataIndexesCache = new int[dataCount];
                tDataIndexCache.set(dataIndexesCache);
            }
            Arrays.fill(dataIndexesCache, 0);
            for (j = 0; j < count; ++j) {
                short yMax = heightAndDepth[j * 2];
                short yMin = heightAndDepth[j * 2 + 1];
                if (yMin == 0 && yMax == 0 || j >= heightAndDepth.length / 2) break;
                int numberOfChildren = 0;
                allEmpty = true;
                allVoid = true;
                int tempAlpha = 0;
                int tempRed = 0;
                int tempGreen = 0;
                int tempBlue = 0;
                int tempLightBlock = 0;
                int tempLightSky = 0;
                long data = 0L;
                for (int index = 0; index < dataCount; ++index) {
                    long singleData;
                    while (dataIndexesCache[index] < inputVerticalSize && RenderDataPointUtil.doesDataPointExist(singleData = sourceData.get(index * inputVerticalSize + dataIndexesCache[index])) && !RenderDataPointUtil.isVoid(singleData)) {
                        int n = index;
                        dataIndexesCache[n] = dataIndexesCache[n] + 1;
                        if ((yMin > RenderDataPointUtil.getYMin(singleData) || RenderDataPointUtil.getYMin(singleData) >= yMax) && (yMin >= RenderDataPointUtil.getYMax(singleData) || RenderDataPointUtil.getYMax(singleData) > yMax)) continue;
                        data = singleData;
                        break;
                    }
                    if (!RenderDataPointUtil.doesDataPointExist(data)) {
                        data = RenderDataPointUtil.createVoidDataPoint(genMode);
                    }
                    if (!RenderDataPointUtil.doesDataPointExist(data)) continue;
                    allEmpty = false;
                    if (RenderDataPointUtil.isVoid(data)) continue;
                    ++numberOfChildren;
                    allVoid = false;
                    tempAlpha = Math.max(RenderDataPointUtil.getAlpha(data), tempAlpha);
                    tempRed += RenderDataPointUtil.getRed(data) * RenderDataPointUtil.getRed(data);
                    tempGreen += RenderDataPointUtil.getGreen(data) * RenderDataPointUtil.getGreen(data);
                    tempBlue += RenderDataPointUtil.getBlue(data) * RenderDataPointUtil.getBlue(data);
                    tempLightBlock += RenderDataPointUtil.getLightBlock(data);
                    tempLightSky += RenderDataPointUtil.getLightSky(data);
                }
                if (dataCount != 1) {
                    tempRed /= numberOfChildren;
                    tempGreen /= numberOfChildren;
                    tempBlue /= numberOfChildren;
                    tempLightBlock /= numberOfChildren;
                    tempLightSky /= numberOfChildren;
                }
                output.set(j, RenderDataPointUtil.createDataPoint(tempAlpha, (int)Math.sqrt(tempRed), (int)Math.sqrt(tempGreen), (int)Math.sqrt(tempBlue), yMax, yMin, tempLightSky, tempLightBlock, genMode));
            }
        }
    }
}

