/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import com.seibel.distanthorizons.core.util.LodUtil;
import org.jetbrains.annotations.Contract;

public class FullDataPointUtil {
    public static final int EMPTY_DATA_POINT = 0;
    public static final int ID_WIDTH = 32;
    public static final int DP_WIDTH = 12;
    public static final int Y_WIDTH = 12;
    public static final int LIGHT_WIDTH = 8;
    public static final int ID_OFFSET = 0;
    public static final int DP_OFFSET = 32;
    public static final int Y_OFFSET = 44;
    public static final int LIGHT_OFFSET = 56;
    public static final long ID_MASK = Integer.MAX_VALUE;
    public static final long INVERSE_ID_MASK = Integer.MIN_VALUE;
    public static final int DP_MASK = (int)Math.pow(2.0, 12.0) - 1;
    public static final int Y_MASK = (int)Math.pow(2.0, 12.0) - 1;
    public static final int LIGHT_MASK = (int)Math.pow(2.0, 8.0) - 1;

    public static long encode(int id, int depth, int y, byte lightPair) {
        LodUtil.assertTrue(y >= 0 && y < 4096, "Trying to create datapoint with y[{}] out of range!", y);
        LodUtil.assertTrue(depth > 0 && depth < 4096, "Trying to create datapoint with depth[{}] out of range!", depth);
        LodUtil.assertTrue(y + depth <= 4096, "Trying to create datapoint with y+depth[{}] out of range!", y + depth);
        long data = 0L;
        data |= (long)id & Integer.MAX_VALUE;
        data |= (long)(depth & DP_MASK) << 32;
        data |= (long)(y & Y_MASK) << 44;
        LodUtil.assertTrue(FullDataPointUtil.getId(data |= (long)lightPair << 56) == id && FullDataPointUtil.getHeight(data) == depth && FullDataPointUtil.getBottomY(data) == y && FullDataPointUtil.getLight(data) == Byte.toUnsignedInt(lightPair), "Trying to create datapoint with id[{}], depth[{}], y[{}], lightPair[{}] but got id[{}], depth[{}], y[{}], lightPair[{}]!", id, depth, y, Byte.toUnsignedInt(lightPair), FullDataPointUtil.getId(data), FullDataPointUtil.getHeight(data), FullDataPointUtil.getBottomY(data), FullDataPointUtil.getLight(data));
        return data;
    }

    public static int getId(long data) {
        return (int)(data & Integer.MAX_VALUE);
    }

    public static int getHeight(long data) {
        return (int)(data >> 32 & (long)DP_MASK);
    }

    public static int getBottomY(long data) {
        return (int)(data >> 44 & (long)Y_MASK);
    }

    public static int getLight(long data) {
        return (int)(data >> 56 & (long)LIGHT_MASK);
    }

    public static String toString(long data) {
        return "[ID:" + FullDataPointUtil.getId(data) + ",Y:" + FullDataPointUtil.getBottomY(data) + ",Height:" + FullDataPointUtil.getHeight(data) + ",Light:" + FullDataPointUtil.getLight(data) + "]";
    }

    @Contract(pure=true)
    public static long remap(int[] newIdMapping, long data) {
        return data & Integer.MIN_VALUE | (long)newIdMapping[(int)data];
    }
}

