/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBuffer;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBufferBuilder;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.file.renderfile.IRenderSourceProvider;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.Reference;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadTree;
import java.awt.Color;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;

public class LodRenderSection
implements IDebugRenderable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final DhSectionPos pos;
    private boolean isRenderingEnabled = false;
    private boolean reloadRenderSourceOnceLoaded = false;
    private IRenderSourceProvider renderSourceProvider = null;
    private CompletableFuture<ColumnRenderSource> renderSourceLoadFuture;
    private ColumnRenderSource renderSource;
    private IDhClientLevel level = null;
    private long lastNs = -1L;
    private long lastSwapLocalVersion = -1L;
    private boolean neighborUpdated = false;
    private static final long SWAP_TIMEOUT_IN_NS = 2000000000L;
    private static final long SWAP_BUSY_COLLISION_TIMEOUT_IN_NS = 1000000000L;
    private CompletableFuture<ColumnRenderBuffer> buildRenderBufferFuture = null;
    private final Reference<ColumnRenderBuffer> inactiveRenderBufferRef = new Reference();
    public final AtomicReference<ColumnRenderBuffer> activeRenderBufferRef = new AtomicReference();
    private volatile boolean disposeActiveBuffer = false;
    private final QuadTree<LodRenderSection> parentQuadTree;

    public LodRenderSection(QuadTree<LodRenderSection> parentQuadTree, DhSectionPos pos) {
        this.pos = pos;
        this.parentQuadTree = parentQuadTree;
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus);
    }

    public void enableRendering() {
        this.isRenderingEnabled = true;
    }

    public void disableRendering() {
        this.isRenderingEnabled = false;
    }

    public void loadRenderSource(IRenderSourceProvider renderDataProvider, IDhClientLevel level) {
        this.renderSourceProvider = renderDataProvider;
        this.level = level;
        if (this.renderSourceProvider == null) {
            LOGGER.warn("LodRenderSection [" + this.pos + "] called loadRenderSource with a empty source provider");
            return;
        }
        if (this.renderSource != null || this.renderSourceLoadFuture != null) {
            if (this.activeRenderBufferRef.get() == null) {
                this.markBufferDirty();
            }
            return;
        }
        this.startLoadRenderSourceAsync();
    }

    public void reload(IRenderSourceProvider renderDataProvider) {
        boolean showRenderSectionStatus = Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus.get();
        if (showRenderSectionStatus && this.pos.getDetailLevel() == 6) {
            DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(this.pos, 0.0f, 256.0f, 0.03f, Color.cyan), 0.5, 512.0f));
        }
        this.renderSourceProvider = renderDataProvider;
        if (this.renderSourceProvider == null) {
            LOGGER.warn("LodRenderSection [" + this.pos + "] called reload with a empty source provider");
            return;
        }
        if (!this.isRenderingEnabled) {
            return;
        }
        if (this.renderSourceLoadFuture != null) {
            this.reloadRenderSourceOnceLoaded = true;
            return;
        }
        this.startLoadRenderSourceAsync();
    }

    private void startLoadRenderSourceAsync() {
        this.renderSourceLoadFuture = this.renderSourceProvider.readAsync(this.pos);
        this.renderSourceLoadFuture.whenComplete((renderSource, ex) -> {
            this.renderSource = renderSource;
            this.lastNs = -1L;
            this.markBufferDirty();
            if (this.reloadRenderSourceOnceLoaded) {
                this.reloadRenderSourceOnceLoaded = false;
                this.reload(this.renderSourceProvider);
            }
            this.renderSourceLoadFuture = null;
        });
    }

    public boolean isRenderingEnabled() {
        return this.isRenderingEnabled;
    }

    public ColumnRenderSource getRenderSource() {
        return this.renderSource;
    }

    public boolean canRenderNow() {
        if (this.renderSourceLoadFuture != null || this.buildRenderBufferFuture != null) {
            return false;
        }
        return this.renderSource != null && (this.renderSource.isEmpty() || this.activeRenderBufferRef.get() != null && this.lastSwapLocalVersion != -1L);
    }

    public void markBufferDirty() {
        this.lastSwapLocalVersion = -1L;
    }

    private LodRenderSection[] getNeighbors() {
        LodRenderSection[] adjacentRenderSections = new LodRenderSection[EDhDirection.ADJ_DIRECTIONS.length];
        for (EDhDirection direction : EDhDirection.ADJ_DIRECTIONS) {
            try {
                LodRenderSection adjRenderSection;
                DhSectionPos adjPos = this.pos.getAdjacentPos(direction);
                adjacentRenderSections[direction.ordinal() - 2] = adjRenderSection = this.parentQuadTree.getValue(adjPos);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return adjacentRenderSections;
    }

    private void tellNeighborsUpdated() {
        LodRenderSection[] adjacentRenderSections;
        for (LodRenderSection adj : adjacentRenderSections = this.getNeighbors()) {
            if (adj == null) continue;
            adj.neighborUpdated = true;
        }
    }

    public boolean canBuildBuffer() {
        return this.renderSourceLoadFuture == null && this.renderSource != null && this.buildRenderBufferFuture == null && !this.renderSource.isEmpty() && this.isBufferOutdated();
    }

    private boolean isBufferOutdated() {
        return this.neighborUpdated || this.renderSource.localVersion.get() != this.lastSwapLocalVersion;
    }

    public boolean canSwapBuffer() {
        return this.buildRenderBufferFuture != null && this.buildRenderBufferFuture.isDone();
    }

    public synchronized void disposeRenderData() {
        if (this.buildRenderBufferFuture != null) {
            this.buildRenderBufferFuture.cancel(true);
            this.buildRenderBufferFuture = null;
        }
        this.disposeActiveBuffer = true;
        this.renderSource = null;
        if (this.renderSourceLoadFuture != null) {
            this.renderSourceLoadFuture.cancel(true);
            this.renderSourceLoadFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryBuildAndSwapBuffer() {
        if (this.disposeActiveBuffer && this.activeRenderBufferRef.get() != null) {
            this.disposeActiveBuffer = false;
            ((ColumnRenderBuffer)this.activeRenderBufferRef.getAndSet(null)).close();
            return false;
        }
        boolean didSwapped = false;
        if (this.canBuildBuffer()) {
            boolean showRenderSectionStatus = Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus.get();
            if (showRenderSectionStatus && this.pos.getDetailLevel() == 6) {
                DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(this.pos, 32.0f, 64.0f, 0.2f, Color.yellow), 0.5, 16.0f));
            }
            this.neighborUpdated = false;
            long newVersion = this.renderSource.localVersion.get();
            if (this.lastSwapLocalVersion != newVersion) {
                this.lastSwapLocalVersion = newVersion;
                this.tellNeighborsUpdated();
            }
            LodRenderSection[] adjacentRenderSections = this.getNeighbors();
            ColumnRenderSource[] adjacentSources = new ColumnRenderSource[EDhDirection.ADJ_DIRECTIONS.length];
            for (int i = 0; i < EDhDirection.ADJ_DIRECTIONS.length; ++i) {
                LodRenderSection adj = adjacentRenderSections[i];
                if (adj == null) continue;
                adjacentSources[i] = adj.getRenderSource();
            }
            this.buildRenderBufferFuture = ColumnRenderBufferBuilder.buildBuffersAsync(this.level, this.inactiveRenderBufferRef, this.renderSource, adjacentSources);
        }
        if (this.canSwapBuffer()) {
            this.lastNs = System.nanoTime();
            try {
                ColumnRenderBuffer newBuffer = this.buildRenderBufferFuture.getNow(null);
                if (newBuffer == null) {
                    this.markBufferDirty();
                    boolean newVersion = false;
                    return newVersion;
                }
                LodUtil.assertTrue(newBuffer.buffersUploaded, "The buffer future for " + this.pos + " returned an un-built buffer.");
                ColumnRenderBuffer oldBuffer = this.activeRenderBufferRef.getAndSet(newBuffer);
                if (oldBuffer != null) {
                    oldBuffer.buffersUploaded = false;
                    oldBuffer.close();
                }
                ColumnRenderBuffer swapped = this.inactiveRenderBufferRef.swap(oldBuffer);
                didSwapped = true;
                LodUtil.assertTrue(swapped == null);
            }
            catch (CancellationException e1) {
                this.buildRenderBufferFuture = null;
            }
            catch (CompletionException e) {
                LOGGER.error("Unable to get render buffer for " + this.pos + ".", (Throwable)e);
                this.buildRenderBufferFuture = null;
            }
            finally {
                this.buildRenderBufferFuture = null;
            }
        }
        return didSwapped;
    }

    public String toString() {
        return "LodRenderSection{pos=" + this.pos + ", lodRenderSource=" + this.renderSource + ", loadFuture=" + this.renderSourceLoadFuture + ", isRenderEnabled=" + this.isRenderingEnabled + '}';
    }

    public void dispose() {
        this.disposeRenderData();
        DebugRenderer.unregister(this, Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus);
        if (this.activeRenderBufferRef.get() != null) {
            this.activeRenderBufferRef.get().close();
        }
        if (this.inactiveRenderBufferRef.value != null) {
            ((ColumnRenderBuffer)this.inactiveRenderBufferRef.value).close();
        }
    }

    @Override
    public void debugRender(DebugRenderer debugRenderer) {
        Color color = Color.red;
        if (this.renderSourceProvider == null) {
            color = Color.black;
        } else if (this.renderSourceLoadFuture != null) {
            color = Color.yellow;
        } else if (this.renderSource != null) {
            color = Color.blue;
            if (this.buildRenderBufferFuture != null) {
                color = Color.magenta;
            } else if (this.canRenderNow()) {
                color = Color.cyan;
            } else if (this.canRenderNow() && this.isRenderingEnabled) {
                color = Color.green;
            }
        }
        debugRenderer.renderBox(new DebugRenderer.Box(this.pos, 400.0f, 8.0f, (Object)Objects.hashCode(this), 0.1f, color));
    }
}

