/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pos;

import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhBlockPos2D;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class DhSectionPos {
    public static final byte SECTION_MINIMUM_DETAIL_LEVEL = 6;
    public static final byte SECTION_BLOCK_DETAIL_LEVEL = 6;
    public static final byte SECTION_CHUNK_DETAIL_LEVEL = 10;
    public static final byte SECTION_REGION_DETAIL_LEVEL = 15;
    protected byte detailLevel;
    protected int x;
    protected int z;

    public DhSectionPos(byte detailLevel, int x, int z) {
        this.detailLevel = detailLevel;
        this.x = x;
        this.z = z;
    }

    public DhSectionPos(DhBlockPos blockPos) {
        this(0, blockPos.x, blockPos.z);
        this.convertSelfToDetailLevel((byte)6);
    }

    public DhSectionPos(DhBlockPos2D blockPos) {
        this(0, blockPos.x, blockPos.z);
        this.convertSelfToDetailLevel((byte)6);
    }

    public DhSectionPos(DhChunkPos chunkPos) {
        this(4, chunkPos.x, chunkPos.z);
        this.convertSelfToDetailLevel((byte)10);
    }

    public DhSectionPos(byte detailLevel, DhLodPos dhLodPos) {
        this.detailLevel = detailLevel;
        this.x = dhLodPos.x;
        this.z = dhLodPos.z;
    }

    public DhSectionPos convertNewToDetailLevel(byte newSectionDetailLevel) {
        DhSectionPos newPos = new DhSectionPos(this.detailLevel, this.x, this.z);
        newPos.convertSelfToDetailLevel(newSectionDetailLevel);
        return newPos;
    }

    protected void convertSelfToDetailLevel(byte newDetailLevel) {
        if (newDetailLevel >= this.detailLevel) {
            this.x = Math.floorDiv(this.x, BitShiftUtil.powerOfTwo(newDetailLevel - this.detailLevel));
            this.z = Math.floorDiv(this.z, BitShiftUtil.powerOfTwo(newDetailLevel - this.detailLevel));
        } else {
            this.x *= BitShiftUtil.powerOfTwo(this.detailLevel - newDetailLevel);
            this.z *= BitShiftUtil.powerOfTwo(this.detailLevel - newDetailLevel);
        }
        this.detailLevel = newDetailLevel;
    }

    public byte getDetailLevel() {
        return this.detailLevel;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public DhLodPos getMinCornerLodPos() {
        return this.getMinCornerLodPos((byte)(this.detailLevel - 1));
    }

    public DhLodPos getMinCornerLodPos(byte returnDetailLevel) {
        LodUtil.assertTrue(returnDetailLevel <= this.detailLevel, "returnDetailLevel must be less than sectionDetail");
        byte offset = (byte)(this.detailLevel - returnDetailLevel);
        return new DhLodPos(returnDetailLevel, this.x * BitShiftUtil.powerOfTwo(offset), this.z * BitShiftUtil.powerOfTwo(offset));
    }

    public int getWidthCountForLowerDetailedSection(byte returnDetailLevel) {
        LodUtil.assertTrue(returnDetailLevel <= this.detailLevel, "returnDetailLevel must be less than sectionDetail");
        byte offset = (byte)(this.detailLevel - returnDetailLevel);
        return BitShiftUtil.powerOfTwo(offset);
    }

    public int getBlockWidth() {
        return BitShiftUtil.powerOfTwo(this.detailLevel);
    }

    public DhBlockPos2D getCenterBlockPos() {
        return new DhBlockPos2D(this.getCenterBlockPosX(), this.getCenterBlockPosZ());
    }

    public int getCenterBlockPosX() {
        return this.getCenterBlockPos(true);
    }

    public int getCenterBlockPosZ() {
        return this.getCenterBlockPos(false);
    }

    private int getCenterBlockPos(boolean returnX) {
        int centerBlockPos;
        int n = centerBlockPos = returnX ? this.x : this.z;
        if (this.detailLevel == 0) {
            return centerBlockPos;
        }
        int positionOffset = 0;
        if (this.detailLevel != 1) {
            positionOffset = BitShiftUtil.powerOfTwo(this.detailLevel - 1);
        }
        return centerBlockPos * BitShiftUtil.powerOfTwo(this.detailLevel) + positionOffset;
    }

    public DhSectionPos getChildByIndex(int child0to3) throws IllegalArgumentException, IllegalStateException {
        if (child0to3 < 0 || child0to3 > 3) {
            throw new IllegalArgumentException("child0to3 must be between 0 and 3");
        }
        if (this.detailLevel <= 0) {
            throw new IllegalStateException("section detail must be greater than 0");
        }
        return new DhSectionPos((byte)(this.detailLevel - 1), this.x * 2 + (child0to3 & 1), this.z * 2 + BitShiftUtil.half(child0to3 & 2));
    }

    public int getChildIndexOfParent() {
        return (this.x & 1) + BitShiftUtil.square(this.z & 1);
    }

    public DhSectionPos getParentPos() {
        return new DhSectionPos((byte)(this.detailLevel + 1), BitShiftUtil.half(this.x), BitShiftUtil.half(this.z));
    }

    public DhSectionPos getAdjacentPos(EDhDirection dir) {
        return new DhSectionPos(this.detailLevel, this.x + dir.getNormal().x, this.z + dir.getNormal().z);
    }

    public DhLodPos getSectionBBoxPos() {
        return new DhLodPos(this.detailLevel, this.x, this.z);
    }

    public boolean overlapsExactly(DhSectionPos other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.detailLevel == other.detailLevel) {
            return false;
        }
        if (this.detailLevel > other.detailLevel) {
            return this.equals(other.convertNewToDetailLevel(this.detailLevel));
        }
        return other.equals(this.convertNewToDetailLevel(other.detailLevel));
    }

    public boolean contains(DhSectionPos otherPos) {
        DhBlockPos2D thisMinBlockPos = this.getMinCornerLodPos((byte)0).getCornerBlockPos();
        DhBlockPos2D otherCornerBlockPos = otherPos.getMinCornerLodPos((byte)0).getCornerBlockPos();
        int thisBlockWidth = this.getBlockWidth() - 1;
        DhBlockPos2D thisMaxBlockPos = new DhBlockPos2D(thisMinBlockPos.x + thisBlockWidth, thisMinBlockPos.z + thisBlockWidth);
        return thisMinBlockPos.x <= otherCornerBlockPos.x && otherCornerBlockPos.x <= thisMaxBlockPos.x && thisMinBlockPos.z <= otherCornerBlockPos.z && otherCornerBlockPos.z <= thisMaxBlockPos.z;
    }

    public void forEachChild(Consumer<DhSectionPos> callback) {
        for (int i = 0; i < 4; ++i) {
            callback.accept(this.getChildByIndex(i));
        }
    }

    public void forEachChildAtLevel(byte sectionDetailLevel, Consumer<DhSectionPos> callback) {
        if (sectionDetailLevel == this.detailLevel) {
            callback.accept(this);
            return;
        }
        for (int i = 0; i < 4; ++i) {
            this.getChildByIndex(i).forEachChildAtLevel(sectionDetailLevel, callback);
        }
    }

    public String serialize() {
        return "[" + this.detailLevel + ',' + this.x + ',' + this.z + ']';
    }

    @Nullable
    public static DhSectionPos deserialize(String value) {
        if (value.charAt(0) != '[' || value.charAt(value.length() - 1) != ']') {
            return null;
        }
        String[] split = value.substring(1, value.length() - 1).split(",");
        if (split.length != 3) {
            return null;
        }
        return new DhSectionPos(Byte.parseByte(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
    }

    public String toString() {
        return "{" + this.detailLevel + "*" + this.x + "," + this.z + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != DhSectionPos.class) {
            return false;
        }
        DhSectionPos that = (DhSectionPos)obj;
        return this.detailLevel == that.detailLevel && this.x == that.x && this.z == that.z;
    }

    public int hashCode() {
        return Integer.hashCode(this.detailLevel) ^ Integer.hashCode(this.x) ^ Integer.hashCode(this.z);
    }

    public static class DhMutableSectionPos
    extends DhSectionPos {
        public DhMutableSectionPos(byte sectionDetailLevel, int sectionX, int sectionZ) {
            super(sectionDetailLevel, sectionX, sectionZ);
        }

        public DhMutableSectionPos(DhBlockPos blockPos) {
            super(blockPos);
        }

        public DhMutableSectionPos(DhBlockPos2D blockPos) {
            super(blockPos);
        }

        public DhMutableSectionPos(DhChunkPos chunkPos) {
            super(chunkPos);
        }

        public DhMutableSectionPos(byte detailLevel, DhLodPos dhLodPos) {
            super(detailLevel, dhLodPos);
        }

        public void mutate(byte sectionDetailLevel, int sectionX, int sectionZ) {
            this.detailLevel = sectionDetailLevel;
            this.x = sectionX;
            this.z = sectionZ;
        }

        @Override
        public void convertSelfToDetailLevel(byte newDetailLevel) {
            super.convertSelfToDetailLevel(newDetailLevel);
        }

        public void setDetailLevel(byte sectionDetailLevel) {
            this.detailLevel = sectionDetailLevel;
        }

        public void setX(int sectionX) {
            this.x = sectionX;
        }

        public void setZ(int sectionZ) {
            this.z = sectionZ;
        }
    }
}

