/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.logging.f3;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;

public class F3Screen {
    private static final String[] DEFAULT_STRING = new String[]{"", "Distant Horizons version: 2.0.1-a"};
    private static final List<Message> SELF_UPDATE_MESSAGE_LIST = Collections.synchronizedList(new LinkedList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStringToDisplay(List<String> list) {
        list.addAll(Arrays.asList(DEFAULT_STRING));
        List<Message> list2 = SELF_UPDATE_MESSAGE_LIST;
        synchronized (list2) {
            Iterator<Message> iterator = SELF_UPDATE_MESSAGE_LIST.iterator();
            while (iterator.hasNext()) {
                Message message = iterator.next();
                if (message == null) {
                    iterator.remove();
                    continue;
                }
                message.printTo(list);
            }
        }
    }

    public static abstract class Message
    implements Closeable {
        protected Message() {
            SELF_UPDATE_MESSAGE_LIST.add(this);
        }

        public abstract void printTo(List<String> var1);

        @Override
        public void close() {
            boolean removed = SELF_UPDATE_MESSAGE_LIST.remove(this);
        }
    }

    public static class NestedMessage
    extends Message {
        private final Supplier<String[]> supplier;

        public NestedMessage(Supplier<String[]> message) {
            this.supplier = message;
        }

        @Override
        public void printTo(List<String> list) {
            String[] message = this.supplier.get();
            if (message != null) {
                list.addAll(Arrays.asList(message));
            }
        }
    }

    public static class MultiDynamicMessage
    extends Message {
        private final Supplier<String>[] supplierList;

        @SafeVarargs
        public MultiDynamicMessage(Supplier<String> ... suppliers) {
            this.supplierList = suppliers;
        }

        @Override
        public void printTo(List<String> list) {
            for (Supplier<String> supplier : this.supplierList) {
                String message = supplier.get();
                if (message == null) continue;
                list.add(message);
            }
        }
    }

    public static class DynamicMessage
    extends Message {
        private final Supplier<String> supplier;

        public DynamicMessage(Supplier<String> message) {
            this.supplier = message;
        }

        @Override
        public void printTo(List<String> list) {
            String message = this.supplier.get();
            if (message != null) {
                list.add(message);
            }
        }
    }

    public static class StaticMessage
    extends Message {
        private final String[] lines;

        public StaticMessage(String ... lines) {
            this.lines = lines;
        }

        @Override
        public void printTo(List<String> output) {
            output.addAll(Arrays.asList(this.lines));
        }
    }
}

