/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.generation.tasks;

import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenResult;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenTask;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Consumer;

public final class WorldGenTaskGroup {
    public final DhSectionPos pos;
    public byte dataDetail;
    public final LinkedList<WorldGenTask> worldGenTasks = new LinkedList();

    public WorldGenTaskGroup(DhSectionPos pos, byte dataDetail) {
        this.pos = pos;
        this.dataDetail = dataDetail;
    }

    public void consumeChunkData(ChunkSizedFullDataAccessor chunkSizedFullDataView) {
        Iterator tasks = this.worldGenTasks.iterator();
        while (tasks.hasNext()) {
            WorldGenTask task = (WorldGenTask)tasks.next();
            Consumer<ChunkSizedFullDataAccessor> chunkDataConsumer = task.taskTracker.getChunkDataConsumer();
            if (chunkDataConsumer == null) {
                tasks.remove();
                task.future.complete(WorldGenResult.CreateFail());
                continue;
            }
            chunkDataConsumer.accept(chunkSizedFullDataView);
        }
    }
}

