/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.generation;

import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.SingleColumnFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.logging.log4j.Logger;

public class MissingWorldGenPositionFinder {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    public static ArrayList<DhSectionPos> getUngeneratedPosList(IFullDataSource dataSource, byte generatorDetailLevel, boolean onlyReturnPositionsTheGeneratorCanAccept) {
        ArrayList<DhSectionPos> posArray = MissingWorldGenPositionFinder.getUngeneratedPosListForQuadrant(dataSource, dataSource.getSectionPos(), generatorDetailLevel);
        if (onlyReturnPositionsTheGeneratorCanAccept) {
            LinkedList<DhSectionPos> posList = new LinkedList<DhSectionPos>(posArray);
            ArrayList<DhSectionPos> cleanedPosArray = new ArrayList<DhSectionPos>();
            while (posList.size() > 0) {
                DhSectionPos pos = posList.remove();
                if (pos.getDetailLevel() > generatorDetailLevel) {
                    pos.forEachChild(childPos -> posList.push((DhSectionPos)childPos));
                    continue;
                }
                cleanedPosArray.add(pos);
            }
            return cleanedPosArray;
        }
        return posArray;
    }

    private static ArrayList<DhSectionPos> getUngeneratedPosListForQuadrant(IFullDataSource dataSource, DhSectionPos quadrantPos, byte generatorDetailLevel) {
        ArrayList<DhSectionPos> ungeneratedPosList = new ArrayList<DhSectionPos>();
        int sourceRelWidthInDataPoints = dataSource.getWidthInDataPoints();
        if (quadrantPos.getDetailLevel() == generatorDetailLevel) {
            ESectionPopulationState populationState = MissingWorldGenPositionFinder.getPopulationStateForPos(dataSource, quadrantPos, sourceRelWidthInDataPoints);
            if (populationState != ESectionPopulationState.COMPLETE) {
                ungeneratedPosList.add(quadrantPos);
            }
        } else if (quadrantPos.getDetailLevel() > generatorDetailLevel) {
            for (int i = 0; i < 4; ++i) {
                DhSectionPos inputPos = quadrantPos.getChildByIndex(i);
                ESectionPopulationState populationState = MissingWorldGenPositionFinder.getPopulationStateForPos(dataSource, inputPos, sourceRelWidthInDataPoints);
                if (populationState == ESectionPopulationState.COMPLETE) continue;
                if (populationState == ESectionPopulationState.EMPTY) {
                    ungeneratedPosList.add(inputPos);
                    continue;
                }
                if (populationState != ESectionPopulationState.PARTIAL) continue;
                ungeneratedPosList.addAll(MissingWorldGenPositionFinder.getUngeneratedPosListForQuadrant(dataSource, inputPos, generatorDetailLevel));
            }
        } else {
            throw new IllegalArgumentException("detail level lower than world generator can accept.");
        }
        return ungeneratedPosList;
    }

    private static ESectionPopulationState getPopulationStateForPos(IFullDataSource dataSource, DhSectionPos inputPos, int sourceRelWidthInDataPoints) {
        byte childDetailLevel = inputPos.getDetailLevel();
        int quadrantDetailLevelDiff = dataSource.getSectionPos().getDetailLevel() - childDetailLevel;
        int widthInSecPos = BitShiftUtil.powerOfTwo(quadrantDetailLevelDiff);
        int relWidthForSecPos = sourceRelWidthInDataPoints / widthInSecPos;
        DhSectionPos minSecPos = dataSource.getSectionPos().convertNewToDetailLevel(childDetailLevel);
        int minRelX = inputPos.getX() - minSecPos.getX();
        int maxRelX = minRelX + 1;
        int minRelZ = inputPos.getZ() - minSecPos.getZ();
        int maxRelZ = minRelZ + 1;
        minRelX *= relWidthForSecPos;
        maxRelX *= relWidthForSecPos;
        minRelZ *= relWidthForSecPos;
        maxRelZ *= relWidthForSecPos;
        boolean quadrantFullyGenerated = true;
        boolean quadrantEmpty = true;
        for (int relX = minRelX; relX < maxRelX; ++relX) {
            for (int relZ = minRelZ; relZ < maxRelZ; ++relZ) {
                SingleColumnFullDataAccessor column = dataSource.tryGet(relX, relZ);
                if (column == null || !column.doesColumnExist()) {
                    quadrantFullyGenerated = false;
                    continue;
                }
                quadrantEmpty = false;
            }
        }
        if (quadrantFullyGenerated) {
            return ESectionPopulationState.COMPLETE;
        }
        if (quadrantEmpty) {
            return ESectionPopulationState.EMPTY;
        }
        return ESectionPopulationState.PARTIAL;
    }

    private static enum ESectionPopulationState {
        COMPLETE,
        EMPTY,
        PARTIAL;

    }
}

