/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.metaData;

import com.seibel.distanthorizons.core.file.metaData.BaseMetaData;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.AbstractDhRepo;
import com.seibel.distanthorizons.core.sql.MetaDataDto;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import org.apache.logging.log4j.Logger;

public abstract class AbstractMetaDataContainerFile {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public volatile BaseMetaData baseMetaData = null;
    public final DhSectionPos pos;

    protected AbstractMetaDataContainerFile(DhSectionPos pos) {
        this.pos = pos;
    }

    protected AbstractMetaDataContainerFile(BaseMetaData baseMetaData) throws IOException {
        this.baseMetaData = baseMetaData;
        this.pos = this.baseMetaData.pos;
    }

    public void writeToDatabase(IMetaDataWriterFunc<DhDataOutputStream> dataWriterFunc, AbstractDhRepo<MetaDataDto> repo) throws IOException {
        LodUtil.assertTrue(this.baseMetaData != null);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            CheckedOutputStream checkedOut = new CheckedOutputStream(byteArrayOutputStream, new Adler32());
            DhDataOutputStream compressedOut = new DhDataOutputStream(checkedOut);
            dataWriterFunc.writeBinaryDataToStream(compressedOut);
            compressedOut.flush();
            this.baseMetaData.checksum = (int)checkedOut.getChecksum().getValue();
            byteArrayOutputStream.close();
            MetaDataDto dto = new MetaDataDto(this.baseMetaData, byteArrayOutputStream.toByteArray());
            repo.save(dto);
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    @FunctionalInterface
    public static interface IMetaDataWriterFunc<T> {
        public void writeBinaryDataToStream(T var1) throws IOException;
    }
}

