/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.loader.AbstractFullDataSourceLoader;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.CompleteFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.HighDetailIncompleteFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.LowDetailIncompleteFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IIncompleteFullDataSource;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataMetaFile;
import com.seibel.distanthorizons.core.file.fullDatafile.IFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.sql.FullDataRepo;
import com.seibel.distanthorizons.core.sql.MetaDataDto;
import com.seibel.distanthorizons.core.util.LodUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FullDataFileHandler
implements IFullDataSourceProvider {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    protected final ConcurrentHashMap<DhSectionPos, FullDataMetaFile> loadedMetaFileBySectionPos = new ConcurrentHashMap();
    protected final IDhLevel level;
    protected final File saveDir;
    protected final AtomicInteger topDetailLevelRef = new AtomicInteger(0);
    protected final int minDetailLevel = 6;
    public final FullDataRepo fullDataRepo;

    @Override
    public FullDataRepo getRepo() {
        return this.fullDataRepo;
    }

    public FullDataFileHandler(IDhLevel level, AbstractSaveStructure saveStructure) {
        this(level, saveStructure, null);
    }

    public FullDataFileHandler(IDhLevel level, AbstractSaveStructure saveStructure, @Nullable File saveDirOverride) {
        this.level = level;
        File file = this.saveDir = saveDirOverride == null ? saveStructure.getFullDataFolder(level.getLevelWrapper()) : saveDirOverride;
        if (!this.saveDir.exists() && !this.saveDir.mkdirs()) {
            LOGGER.warn("Unable to create full data folder, file saving may fail.");
        }
        try {
            this.fullDataRepo = new FullDataRepo("jdbc:sqlite", this.saveDir.getPath() + "/" + "DistantHorizons.sqlite");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<IFullDataSource> readAsync(DhSectionPos pos) {
        this.topDetailLevelRef.updateAndGet(oldDetailLevel -> Math.max(oldDetailLevel, pos.getDetailLevel()));
        FullDataMetaFile metaFile = this.getLoadOrMakeFile(pos, true);
        if (metaFile == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<IFullDataSource> futureWrapper = new CompletableFuture<IFullDataSource>();
        ((CompletableFuture)metaFile.getOrLoadCachedDataSourceAsync().exceptionally(e -> {
            FullDataMetaFile newMetaFile = this.removeCorruptedFile(pos, (Throwable)e);
            futureWrapper.completeExceptionally((Throwable)e);
            return null;
        })).whenComplete((dataSource, e) -> futureWrapper.complete((IFullDataSource)dataSource));
        return futureWrapper;
    }

    @Override
    public FullDataMetaFile getFileIfExist(DhSectionPos pos) {
        return this.getLoadOrMakeFile(pos, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FullDataMetaFile getLoadOrMakeFile(DhSectionPos pos, boolean allowCreateFile) {
        FullDataMetaFile metaFile = this.loadedMetaFileBySectionPos.get(pos);
        if (metaFile != null) {
            return metaFile;
        }
        MetaDataDto metaDataDto = (MetaDataDto)this.fullDataRepo.getByPrimaryKey(pos.serialize());
        if (metaDataDto != null) {
            FullDataFileHandler fullDataFileHandler = this;
            synchronized (fullDataFileHandler) {
                metaFile = this.loadedMetaFileBySectionPos.get(pos);
                if (metaFile != null) {
                    return metaFile;
                }
                try {
                    metaFile = FullDataMetaFile.createFromExistingDto(this, this.level, metaDataDto);
                    this.topDetailLevelRef.updateAndGet(oldDetailLevel -> Math.max(oldDetailLevel, pos.getDetailLevel()));
                    this.loadedMetaFileBySectionPos.put(pos, metaFile);
                    return metaFile;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to read meta data file at pos " + pos + ": ", (Throwable)e);
                    this.fullDataRepo.delete(metaDataDto);
                }
            }
        }
        if (!allowCreateFile) {
            return null;
        }
        try {
            metaFile = FullDataMetaFile.createNewDtoForPos(this, this.level, pos);
        }
        catch (IOException e) {
            LOGGER.error("IOException on creating new data file at {}", (Object)pos, (Object)e);
            return null;
        }
        this.topDetailLevelRef.updateAndGet(oldDetailLevel -> Math.max(oldDetailLevel, pos.getDetailLevel()));
        FullDataMetaFile metaFileCas = this.loadedMetaFileBySectionPos.putIfAbsent(pos, metaFile);
        return metaFileCas == null ? metaFile : metaFileCas;
    }

    protected void getDataFilesForPosition(DhSectionPos effectivePos, DhSectionPos posAreaToGet, ArrayList<FullDataMetaFile> preexistingFiles, ArrayList<DhSectionPos> missingFilePositions) {
        int sectionDetail = posAreaToGet.getDetailLevel();
        boolean allEmpty = true;
        DhSectionPos.DhMutableSectionPos subPos = new DhSectionPos.DhMutableSectionPos(0, 0, 0);
        block0: while ((sectionDetail = (byte)(sectionDetail - 1)) >= this.minDetailLevel) {
            DhLodPos minPos = posAreaToGet.getMinCornerLodPos().getCornerLodPos((byte)sectionDetail);
            int count = posAreaToGet.getSectionBBoxPos().getWidthAtDetail((byte)sectionDetail);
            for (int xOffset = 0; xOffset < count; ++xOffset) {
                for (int zOffset = 0; zOffset < count; ++zOffset) {
                    subPos.mutate((byte)sectionDetail, xOffset + minPos.x, zOffset + minPos.z);
                    LodUtil.assertTrue(posAreaToGet.overlapsExactly(effectivePos) && subPos.overlapsExactly(posAreaToGet));
                    if (!CompleteFullDataSource.firstDataPosCanAffectSecond(effectivePos, subPos) || !this.loadedMetaFileBySectionPos.containsKey(subPos) && !this.fullDataRepo.existsWithPrimaryKey(subPos.serialize())) continue;
                    allEmpty = false;
                    break block0;
                }
            }
        }
        if (allEmpty) {
            missingFilePositions.add(posAreaToGet);
        } else {
            this.recursiveGetDataFilesForPosition(0, effectivePos, posAreaToGet, preexistingFiles, missingFilePositions);
            this.recursiveGetDataFilesForPosition(1, effectivePos, posAreaToGet, preexistingFiles, missingFilePositions);
            this.recursiveGetDataFilesForPosition(2, effectivePos, posAreaToGet, preexistingFiles, missingFilePositions);
            this.recursiveGetDataFilesForPosition(3, effectivePos, posAreaToGet, preexistingFiles, missingFilePositions);
        }
    }

    private void recursiveGetDataFilesForPosition(int childIndex, DhSectionPos basePos, DhSectionPos pos, ArrayList<FullDataMetaFile> preexistingFiles, ArrayList<DhSectionPos> missingFilePositions) {
        DhSectionPos childPos = pos.getChildByIndex(childIndex);
        if (CompleteFullDataSource.firstDataPosCanAffectSecond(basePos, childPos)) {
            FullDataMetaFile metaFile;
            if (!this.loadedMetaFileBySectionPos.containsKey(childPos)) {
                this.getLoadOrMakeFile(childPos, false);
            }
            if ((metaFile = this.loadedMetaFileBySectionPos.get(childPos)) != null) {
                preexistingFiles.add(metaFile);
            } else if (childPos.getDetailLevel() == this.minDetailLevel) {
                missingFilePositions.add(childPos);
            } else {
                this.getDataFilesForPosition(basePos, childPos, preexistingFiles, missingFilePositions);
            }
        }
    }

    public void ForEachFile(Consumer<FullDataMetaFile> consumer) {
        this.loadedMetaFileBySectionPos.values().forEach(consumer);
    }

    @Override
    public void writeChunkDataToFile(DhSectionPos sectionPos, ChunkSizedFullDataAccessor chunkDataView) {
        DhSectionPos chunkSectionPos = chunkDataView.getSectionPos();
        LodUtil.assertTrue(chunkSectionPos.overlapsExactly(sectionPos), "Chunk " + chunkSectionPos + " does not overlap section " + sectionPos);
        chunkSectionPos = chunkSectionPos.convertNewToDetailLevel((byte)this.minDetailLevel);
        this.writeChunkDataToMetaFile(chunkSectionPos, chunkDataView);
    }

    private void writeChunkDataToMetaFile(DhSectionPos sectionPos, ChunkSizedFullDataAccessor chunkData) {
        FullDataMetaFile metaFile = this.loadedMetaFileBySectionPos.get(sectionPos);
        if (metaFile != null) {
            metaFile.addToWriteQueue(chunkData);
        }
        if (sectionPos.getDetailLevel() <= this.topDetailLevelRef.get()) {
            this.writeChunkDataToMetaFile(sectionPos.getParentPos(), chunkData);
        }
    }

    @Override
    public CompletableFuture<Void> flushAndSaveAsync() {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (FullDataMetaFile metaFile : this.loadedMetaFileBySectionPos.values()) {
            futures.add(metaFile.flushAndSaveAsync());
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    @Override
    public CompletableFuture<Void> flushAndSaveAsync(DhSectionPos sectionPos) {
        FullDataMetaFile metaFile = this.loadedMetaFileBySectionPos.get(sectionPos);
        if (metaFile == null) {
            return CompletableFuture.completedFuture(null);
        }
        return metaFile.flushAndSaveAsync();
    }

    protected IIncompleteFullDataSource makeEmptyDataSource(DhSectionPos pos) {
        return pos.getDetailLevel() <= 10 ? HighDetailIncompleteFullDataSource.createEmpty(pos) : LowDetailIncompleteFullDataSource.createEmpty(pos);
    }

    protected CompletableFuture<IIncompleteFullDataSource> sampleFromFileArray(IIncompleteFullDataSource recipientFullDataSource, ArrayList<FullDataMetaFile> existingFiles, boolean usePooledDataSources) {
        boolean showFullDataFileSampling = Config.Client.Advanced.Debugging.DebugWireframe.showFullDataFileSampling.get();
        if (showFullDataFileSampling) {
            DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(recipientFullDataSource.getSectionPos(), 64.0f, 72.0f, 0.03f, Color.MAGENTA), 0.2, 32.0f));
        }
        ArrayList<CompletionStage> sampleDataFutures = new ArrayList<CompletionStage>(existingFiles.size());
        for (int i = 0; i < existingFiles.size(); ++i) {
            FullDataMetaFile existingFile = existingFiles.get(i);
            CompletableFuture<IFullDataSource> loadFileFuture = usePooledDataSources ? existingFile.getDataSourceWithoutCachingAsync() : existingFile.getOrLoadCachedDataSourceAsync();
            CompletionStage sampleSourceFuture = loadFileFuture.whenComplete((existingFullDataSource, ex) -> {
                if (existingFullDataSource == null || ex != null) {
                    return;
                }
                if (showFullDataFileSampling) {
                    DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(recipientFullDataSource.getSectionPos(), 64.0f, 72.0f, 0.03f, Color.MAGENTA.darker()), 0.2, 32.0f));
                }
                try {
                    recipientFullDataSource.sampleFrom((IFullDataSource)existingFullDataSource);
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to sample " + existingFullDataSource.getSectionPos() + " into " + recipientFullDataSource.getSectionPos(), (Throwable)e);
                }
                if (usePooledDataSources && !existingFile.cacheLoadingDataSource.booleanValue()) {
                    existingFile.clearCachedDataSource();
                    AbstractFullDataSourceLoader dataSourceLoader = existingFile.fullDataSourceLoader != null ? existingFile.fullDataSourceLoader : AbstractFullDataSourceLoader.getLoader(existingFile.baseMetaData.dataType, existingFile.baseMetaData.binaryDataFormatVersion);
                    dataSourceLoader.returnPooledDataSource((IFullDataSource)existingFullDataSource);
                }
            });
            sampleDataFutures.add(sampleSourceFuture);
        }
        return CompletableFuture.allOf(sampleDataFutures.toArray(new CompletableFuture[0])).thenApply(voidObj -> recipientFullDataSource);
    }

    protected void makeFiles(ArrayList<DhSectionPos> posList, ArrayList<FullDataMetaFile> output) {
        for (DhSectionPos missingPos : posList) {
            FullDataMetaFile newFile = this.getLoadOrMakeFile(missingPos, true);
            if (newFile == null) continue;
            output.add(newFile);
        }
    }

    @Override
    public CompletableFuture<IFullDataSource> onDataFileCreatedAsync(FullDataMetaFile file) {
        DhSectionPos pos = file.pos;
        IIncompleteFullDataSource source = this.makeEmptyDataSource(pos);
        ArrayList<FullDataMetaFile> existFiles = new ArrayList<FullDataMetaFile>();
        ArrayList<DhSectionPos> missing = new ArrayList<DhSectionPos>();
        this.getDataFilesForPosition(pos, pos, existFiles, missing);
        LodUtil.assertTrue(!missing.isEmpty() || !existFiles.isEmpty());
        if (missing.size() == 1 && existFiles.isEmpty() && missing.get(0).equals(pos)) {
            return CompletableFuture.completedFuture(source);
        }
        this.makeFiles(missing, existFiles);
        return ((CompletableFuture)this.sampleFromFileArray(source, existFiles, true).thenApply(IIncompleteFullDataSource::tryPromotingToCompleteDataSource)).exceptionally(e -> {
            FullDataMetaFile newMetaFile = this.removeCorruptedFile(pos, (Throwable)e);
            return null;
        });
    }

    protected FullDataMetaFile removeCorruptedFile(DhSectionPos pos, Throwable exception) {
        LOGGER.error("Error reading Data file [" + pos + "]", exception);
        this.fullDataRepo.deleteByPrimaryKey(pos.serialize());
        this.loadedMetaFileBySectionPos.remove(pos);
        return this.getLoadOrMakeFile(pos, true);
    }

    @Override
    public void close() {
        FullDataMetaFile.checkAndLogPhantomDataSourceLifeCycles();
        this.fullDataRepo.close();
    }
}

