/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.file.renderfile.RenderDataMetaFile;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.logging.log4j.Logger;

public class ColumnRenderLoader {
    public static ColumnRenderLoader INSTANCE = new ColumnRenderLoader();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    private ColumnRenderLoader() {
    }

    public ColumnRenderSource loadRenderSource(RenderDataMetaFile dataFile, DhDataInputStream inputStream, IDhLevel level) throws IOException {
        byte dataFileVersion = dataFile.baseMetaData.binaryDataFormatVersion;
        switch (dataFileVersion) {
            case 1: {
                ParsedColumnData parsedColumnData = ColumnRenderLoader.readDataV1(inputStream, level.getMinY());
                if (parsedColumnData.isEmpty) {
                    LOGGER.warn("Empty render file " + dataFile.pos);
                }
                return new ColumnRenderSource(dataFile.pos, parsedColumnData, level);
            }
        }
        throw new IOException("Invalid Data: The data version [" + dataFileVersion + "] is not supported");
    }

    private static ParsedColumnData readDataV1(DhDataInputStream inputStream, int expectedYOffset) throws IOException {
        byte guardByteFlag;
        byte detailLevel = inputStream.readByte();
        int verticalDataCount = inputStream.readInt();
        if (verticalDataCount <= 0) {
            throw new IOException("Invalid data: vertical size must be 0 or greater");
        }
        int maxNumberOfDataPoints = ColumnRenderSource.SECTION_SIZE * ColumnRenderSource.SECTION_SIZE * verticalDataCount;
        byte dataPresentFlag = inputStream.readByte();
        if (dataPresentFlag != 1 && dataPresentFlag != -1) {
            throw new IOException("Incorrect render file format. Expected either: NO_DATA_FLAG_BYTE [1] or DATA_GUARD_BYTE [-1], Found: [" + dataPresentFlag + "]");
        }
        if (dataPresentFlag == 1) {
            return new ParsedColumnData(detailLevel, verticalDataCount, EDhApiWorldGenerationStep.EMPTY, new long[maxNumberOfDataPoints], true);
        }
        int fileYOffset = inputStream.readInt();
        if (fileYOffset != expectedYOffset) {
            throw new IOException("Invalid data: yOffset is incorrect. Expected: [" + expectedYOffset + "], found: [" + fileYOffset + "].");
        }
        byte[] rawByteData = new byte[maxNumberOfDataPoints * 8];
        ByteBuffer columnDataByteBuffer = ByteBuffer.wrap(rawByteData).order(ByteOrder.LITTLE_ENDIAN);
        inputStream.readFully(rawByteData);
        long[] dataPoints = new long[maxNumberOfDataPoints];
        columnDataByteBuffer.asLongBuffer().get(dataPoints);
        boolean isEmpty = true;
        for (long dataPoint : dataPoints) {
            if (dataPoint == 0L) continue;
            isEmpty = false;
            break;
        }
        if ((guardByteFlag = inputStream.readByte()) != -1) {
            throw new IOException("invalid world gen step end guard");
        }
        EDhApiWorldGenerationStep worldGenStep = EDhApiWorldGenerationStep.fromValue(inputStream.readByte());
        if (worldGenStep == null) {
            LOGGER.warn("Missing WorldGenStep, defaulting to: " + EDhApiWorldGenerationStep.SURFACE.name());
            worldGenStep = EDhApiWorldGenerationStep.SURFACE;
        }
        return new ParsedColumnData(detailLevel, verticalDataCount, worldGenStep, dataPoints, isEmpty);
    }

    public static class ParsedColumnData {
        public final byte detailLevel;
        public final int verticalSize;
        public final EDhApiWorldGenerationStep worldGenStep;
        public final long[] dataContainer;
        public final boolean isEmpty;

        public ParsedColumnData(byte detailLevel, int verticalSize, EDhApiWorldGenerationStep worldGenStep, long[] dataContainer, boolean isEmpty) {
            this.detailLevel = detailLevel;
            this.verticalSize = verticalSize;
            this.worldGenStep = worldGenStep;
            this.dataContainer = dataContainer;
            this.isEmpty = isEmpty;
        }
    }
}

