/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataMetaFile;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.IOException;

public interface IStreamableFullDataSource<SummaryDataType extends FullDataSourceSummaryData, DataContainerType>
extends IFullDataSource {
    @Override
    default public void repopulateFromStream(FullDataMetaFile dataFile, DhDataInputStream inputStream, IDhLevel level) throws IOException, InterruptedException {
        this.resizeDataStructuresForRepopulation(dataFile.pos);
        this.getMapping().clear(dataFile.pos);
        this.populateFromStream(dataFile, inputStream, level);
    }

    @Override
    default public void populateFromStream(FullDataMetaFile dataFile, DhDataInputStream inputStream, IDhLevel level) throws IOException, InterruptedException {
        SummaryDataType summaryData = this.readSourceSummaryInfo(dataFile, inputStream, level);
        this.setSourceSummaryData(summaryData);
        DataContainerType dataPoints = this.readDataPoints(dataFile, ((FullDataSourceSummaryData)summaryData).dataWidth, inputStream);
        if (dataPoints == null) {
            return;
        }
        this.setDataPoints(dataPoints);
        FullDataPointIdMap mapping = this.readIdMappings(dataPoints, inputStream, level.getLevelWrapper());
        this.setIdMapping(mapping);
    }

    @Override
    default public void writeToStream(DhDataOutputStream outputStream, IDhLevel level) throws IOException {
        this.writeSourceSummaryInfo(level, outputStream);
        boolean hasData = this.writeDataPoints(outputStream);
        if (!hasData) {
            return;
        }
        this.writeIdMappings(outputStream);
    }

    public void resizeDataStructuresForRepopulation(DhSectionPos var1);

    public void writeSourceSummaryInfo(IDhLevel var1, DhDataOutputStream var2) throws IOException;

    public SummaryDataType readSourceSummaryInfo(FullDataMetaFile var1, DhDataInputStream var2, IDhLevel var3) throws IOException;

    public void setSourceSummaryData(SummaryDataType var1);

    public boolean writeDataPoints(DhDataOutputStream var1) throws IOException;

    public DataContainerType readDataPoints(FullDataMetaFile var1, int var2, DhDataInputStream var3) throws IOException;

    public void setDataPoints(DataContainerType var1);

    public void writeIdMappings(DhDataOutputStream var1) throws IOException;

    public FullDataPointIdMap readIdMappings(DataContainerType var1, DhDataInputStream var2, ILevelWrapper var3) throws IOException, InterruptedException;

    public void setIdMapping(FullDataPointIdMap var1);

    public static class FullDataSourceSummaryData {
        public final int dataWidth;
        public EDhApiWorldGenerationStep worldGenStep;

        public FullDataSourceSummaryData(int dataWidth, EDhApiWorldGenerationStep worldGenStep) {
            this.dataWidth = dataWidth;
            this.worldGenStep = worldGenStep;
        }
    }
}

