/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dqu.additionaladditions.behaviour.BehaviourManager;
import dqu.additionaladditions.behaviour.BehaviourValues;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_5134;

public class AdditionalArmorItem
extends class_1738 {
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private Multimap<class_1320, class_1322> modifiers = null;
    private int previousLoads = BehaviourManager.loads;

    public AdditionalArmorItem(class_1741 armorMaterial, class_1738.class_8051 type, class_1792.class_1793 properties) {
        super(armorMaterial, type, properties);
        this.rebuildModifiers(type.method_48399());
    }

    private void rebuildModifiers(class_1304 slot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIER_UUID_PER_SLOT[slot.method_5927()];
        builder.put((Object)class_5134.field_23724, (Object)new class_1322(uuid, "Armor modifier", (double)this.method_7687(), class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23725, (Object)new class_1322(uuid, "Armor toughness", (double)this.method_26353(), class_1322.class_1323.field_6328));
        if (this.getKnockbackResistance() > 0.0f) {
            builder.put((Object)class_5134.field_23718, (Object)new class_1322(uuid, "Armor knockback resistance", (double)this.getKnockbackResistance(), class_1322.class_1323.field_6328));
        }
        this.modifiers = builder.build();
    }

    private void rebuildModifiersIfNeeded() {
        if (this.modifiers == null) {
            this.rebuildModifiers(this.method_48398().method_48399());
            return;
        }
        if (this.previousLoads != BehaviourManager.loads) {
            this.previousLoads = BehaviourManager.loads;
            this.rebuildModifiers(this.method_48398().method_48399());
        }
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 equipmentSlot) {
        this.rebuildModifiersIfNeeded();
        return this.method_48398().method_48399() == equipmentSlot ? this.modifiers : super.method_7844(equipmentSlot);
    }

    public float method_26353() {
        if (this.method_48398().method_48399().method_5927() > 3 || this.method_48398().method_48399().method_5927() < 0) {
            return super.method_26353();
        }
        String path = this.method_7686().method_7694() + "/" + AdditionalArmorItem.slotIndexToName(this.method_48398().method_48399().method_5927());
        Float toughness = (Float)BehaviourManager.INSTANCE.getBehaviourValue(path, BehaviourValues.TOUGHNESS);
        return toughness == null ? super.method_26353() : toughness.floatValue();
    }

    public int method_7687() {
        if (this.method_48398().method_48399().method_5927() > 3 || this.method_48398().method_48399().method_5927() < 0) {
            return super.method_7687();
        }
        String path = this.method_7686().method_7694() + "/" + AdditionalArmorItem.slotIndexToName(this.method_48398().method_48399().method_5927());
        Integer defense = (Integer)BehaviourManager.INSTANCE.getBehaviourValue(path, BehaviourValues.DEFENSE);
        return defense == null ? super.method_7687() : defense.intValue();
    }

    public float getKnockbackResistance() {
        if (this.method_48398().method_48399().method_5927() > 3 || this.method_48398().method_48399().method_5927() < 0) {
            return 0.0f;
        }
        String path = this.method_7686().method_7694() + "/" + AdditionalArmorItem.slotIndexToName(this.method_48398().method_48399().method_5927());
        Float knockback = (Float)BehaviourManager.INSTANCE.getBehaviourValue(path, BehaviourValues.KNOCKBACK_RESISTANCE);
        return knockback == null ? this.field_21976 : knockback.floatValue();
    }

    private static String slotIndexToName(int slot) {
        if (slot == 0) {
            return "boots";
        }
        if (slot == 1) {
            return "leggings";
        }
        if (slot == 2) {
            return "chestplate";
        }
        if (slot == 3) {
            return "helmet";
        }
        return null;
    }
}

