/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.config;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dqu.additionaladditions.AdditionalAdditions;
import dqu.additionaladditions.config.ConfigProperty;
import dqu.additionaladditions.config.ConfigValues;
import dqu.additionaladditions.config.value.ConfigValueType;
import dqu.additionaladditions.config.value.ListConfigValue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static final int VERSION = 8;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String PATH = FabricLoader.getInstance().getConfigDir().resolve("additional-additions-config.json").toString();
    private static final File DBFILE = new File(PATH);
    public static boolean initialized = false;
    private static JsonObject db;

    private static String format(String message) {
        return String.format("[%s] %s", "additionaladditions", message);
    }

    private static void addPropertyTo(JsonObject object, ConfigProperty property) {
        switch (property.value().getType()) {
            case BOOLEAN: {
                object.addProperty(property.key(), (Boolean)property.value().getValue());
                break;
            }
            case STRING: {
                object.addProperty(property.key(), (String)property.value().getValue());
                break;
            }
            case INTEGER: {
                object.addProperty(property.key(), (Number)((Integer)property.value().getValue()));
                break;
            }
            case FLOAT: {
                object.addProperty(property.key(), (Number)((Float)property.value().getValue()));
                break;
            }
            case LIST: {
                JsonObject newObject = new JsonObject();
                for (ConfigProperty i : (List)property.value().getValue()) {
                    Config.addPropertyTo(newObject, i);
                }
                object.add(property.key(), (JsonElement)newObject);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported config value type: " + property.value().getType());
            }
        }
    }

    public static void load() {
        if (!DBFILE.exists()) {
            Config.createConfig();
        }
        try {
            BufferedReader bufferedReader = Files.newReader((File)DBFILE, (Charset)StandardCharsets.UTF_8);
            db = (JsonObject)GSON.fromJson((Reader)bufferedReader, JsonObject.class);
        }
        catch (Exception e) {
            AdditionalAdditions.LOGGER.error(Config.format("Unable to load configuration file!"), (Throwable)e);
        }
        try {
            if (db.get("version").getAsInt() != 8) {
                Config.convert(db.get("version").getAsInt());
            }
        }
        catch (Exception e) {
            AdditionalAdditions.LOGGER.error(Config.format("Configuration file is damaged!"), (Throwable)e);
            Config.createConfig();
        }
        Config.repair();
        initialized = true;
    }

    private static void createConfig() {
        db = new JsonObject();
        db.addProperty("version", (Number)8);
        for (ConfigValues value : ConfigValues.values()) {
            Config.addPropertyTo(db, value.getProperty());
        }
        Config.save();
    }

    private static void save() {
        try {
            BufferedWriter bufferedWriter = Files.newWriter((File)DBFILE, (Charset)StandardCharsets.UTF_8);
            String json = GSON.toJson((JsonElement)db);
            bufferedWriter.write(json);
            bufferedWriter.close();
        }
        catch (Exception e) {
            AdditionalAdditions.LOGGER.error(Config.format("Unable to save configuration file!"), (Throwable)e);
        }
    }

    public static boolean getBool(ConfigValues value) {
        return Boolean.TRUE.equals(Config.get(value));
    }

    public static boolean getBool(ConfigValues value, String key) {
        return Boolean.TRUE.equals(Config.get(value, key));
    }

    public static <T> T get(ConfigValues value) {
        if (!initialized) {
            Config.load();
        }
        switch (value.getType()) {
            case STRING: {
                return (T)db.get(value.getProperty().key()).getAsString();
            }
            case BOOLEAN: {
                return (T)Boolean.valueOf(db.get(value.getProperty().key()).getAsBoolean());
            }
            case INTEGER: {
                return (T)Integer.valueOf(db.get(value.getProperty().key()).getAsInt());
            }
            case FLOAT: {
                return (T)Float.valueOf(db.get(value.getProperty().key()).getAsFloat());
            }
        }
        return null;
    }

    public static <T> T get(ConfigValues value, String key) {
        if (!initialized) {
            Config.load();
        }
        if (value.getType() == ConfigValueType.LIST) {
            ListConfigValue configValue = (ListConfigValue)value.getProperty().value();
            JsonObject object = db.get(value.getProperty().key()).getAsJsonObject();
            ConfigProperty keyProperty = configValue.get(key);
            switch (keyProperty.value().getType()) {
                case STRING: {
                    return (T)object.get(key).getAsString();
                }
                case BOOLEAN: {
                    return (T)Boolean.valueOf(object.get(key).getAsBoolean());
                }
                case INTEGER: {
                    return (T)Integer.valueOf(object.get(key).getAsInt());
                }
                case FLOAT: {
                    return (T)Float.valueOf(object.get(key).getAsFloat());
                }
                case LIST: {
                    throw new IllegalArgumentException("Cannot put lists inside lists!");
                }
            }
            return null;
        }
        return null;
    }

    public static void set(ConfigValues value, Object property) {
        if (!initialized) {
            Config.load();
        }
        switch (value.getType()) {
            case STRING: {
                if (!(property instanceof String)) break;
                db.addProperty(value.getProperty().key(), (String)property);
                break;
            }
            case BOOLEAN: {
                if (!(property instanceof Boolean)) break;
                db.addProperty(value.getProperty().key(), (Boolean)property);
                break;
            }
            case INTEGER: {
                if (!(property instanceof Integer)) break;
                db.addProperty(value.getProperty().key(), (Number)((Integer)property));
                break;
            }
            case FLOAT: {
                if (!(property instanceof Float)) break;
                db.addProperty(value.getProperty().key(), (Number)((Float)property));
            }
        }
        Config.save();
    }

    private static void convert(int version) {
        for (ConfigValues value : ConfigValues.values()) {
            if (value.getVersion() <= version) continue;
            db.remove(value.getProperty().key());
        }
        db.addProperty("version", (Number)8);
        AdditionalAdditions.LOGGER.info(Config.format("Converted outdated config."));
    }

    private static void repair() {
        int repaired = 0;
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry entry : db.entrySet()) {
            if (ConfigValues.getByName((String)entry.getKey()) != null || ((String)entry.getKey()).equals("version")) continue;
            toRemove.add((String)entry.getKey());
            ++repaired;
        }
        toRemove.forEach(arg_0 -> ((JsonObject)db).remove(arg_0));
        for (ConfigValues value : ConfigValues.values()) {
            if (db.get(value.getProperty().key()) != null) continue;
            Config.addPropertyTo(db, value.getProperty());
            ++repaired;
        }
        if (repaired > 0) {
            AdditionalAdditions.LOGGER.info(Config.format("Repaired " + repaired + " config properties"));
        }
        Config.save();
    }
}

