/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dqu.additionaladditions.config.Config;
import dqu.additionaladditions.config.ConfigValues;
import dqu.additionaladditions.registry.AdditionalBlocks;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2426;
import net.minecraft.class_243;
import net.minecraft.class_2462;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2773;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class CopperPatinaBlock
extends class_2248 {
    public static final class_2754<class_2773> WIRE_CONNECTION_NORTH = class_2741.field_12495;
    public static final class_2754<class_2773> WIRE_CONNECTION_EAST = class_2741.field_12523;
    public static final class_2754<class_2773> WIRE_CONNECTION_SOUTH = class_2741.field_12551;
    public static final class_2754<class_2773> WIRE_CONNECTION_WEST = class_2741.field_12504;
    public static final class_2758 POWER = class_2741.field_12511;
    public static final Map<class_2350, class_2754<class_2773>> DIRECTION_TO_WIRE_CONNECTION_PROPERTY = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, WIRE_CONNECTION_NORTH, (Object)class_2350.field_11034, WIRE_CONNECTION_EAST, (Object)class_2350.field_11035, WIRE_CONNECTION_SOUTH, (Object)class_2350.field_11039, WIRE_CONNECTION_WEST));
    protected static final int field_31222 = 1;
    protected static final int field_31223 = 3;
    protected static final int field_31224 = 13;
    protected static final int field_31225 = 3;
    protected static final int field_31226 = 13;
    private static final class_265 DOT_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<class_2350, class_265> field_24414 = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)class_2350.field_11035, (Object)class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)class_2350.field_11034, (Object)class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)class_2350.field_11039, (Object)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<class_2350, class_265> field_24415 = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_259.method_1084((class_265)field_24414.get(class_2350.field_11043), (class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)class_2350.field_11035, (Object)class_259.method_1084((class_265)field_24414.get(class_2350.field_11035), (class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)class_2350.field_11034, (Object)class_259.method_1084((class_265)field_24414.get(class_2350.field_11034), (class_265)class_2248.method_9541((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)class_2350.field_11039, (Object)class_259.method_1084((class_265)field_24414.get(class_2350.field_11039), (class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private static final Map<class_2680, class_265> SHAPES = Maps.newHashMap();
    private static final class_243[] COLORS = (class_243[])class_156.method_654((Object)new class_243[16], vec3ds -> {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float g = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float h = class_3532.method_15363((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float j = class_3532.method_15363((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            vec3ds[i] = new class_243((double)g, (double)h, (double)j);
        }
    });
    private static final float field_31221 = 0.2f;
    private final class_2680 dotState;
    private boolean wiresGivePower = true;

    public CopperPatinaBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(WIRE_CONNECTION_NORTH, (Comparable)class_2773.field_12687)).method_11657(WIRE_CONNECTION_EAST, (Comparable)class_2773.field_12687)).method_11657(WIRE_CONNECTION_SOUTH, (Comparable)class_2773.field_12687)).method_11657(WIRE_CONNECTION_WEST, (Comparable)class_2773.field_12687)).method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0)));
        this.dotState = (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(WIRE_CONNECTION_NORTH, (Comparable)class_2773.field_12689)).method_11657(WIRE_CONNECTION_EAST, (Comparable)class_2773.field_12689)).method_11657(WIRE_CONNECTION_SOUTH, (Comparable)class_2773.field_12689)).method_11657(WIRE_CONNECTION_WEST, (Comparable)class_2773.field_12689);
        for (class_2680 blockState : this.method_9595().method_11662()) {
            if ((Integer)blockState.method_11654((class_2769)POWER) != 0) continue;
            SHAPES.put(blockState, this.getShapeForState(blockState));
        }
    }

    private class_265 getShapeForState(class_2680 state) {
        class_265 voxelShape = DOT_SHAPE;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2773 wireConnection = (class_2773)state.method_11654((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction));
            if (wireConnection == class_2773.field_12689) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)field_24414.get(direction));
                continue;
            }
            if (wireConnection != class_2773.field_12686) continue;
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)field_24415.get(direction));
        }
        return voxelShape;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPES.get(state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0)));
    }

    public class_2680 method_9605(class_1750 ctx) {
        return this.getPlacementState((class_1922)ctx.method_8045(), this.dotState, ctx.method_8037());
    }

    private class_2680 getPlacementState(class_1922 world, class_2680 state, class_2338 pos) {
        boolean bl7;
        boolean bl = CopperPatinaBlock.isNotConnected(state);
        state = this.method_27843(world, (class_2680)this.method_9564().method_11657((class_2769)POWER, (Comparable)((Integer)state.method_11654((class_2769)POWER))), pos);
        if (bl && CopperPatinaBlock.isNotConnected(state)) {
            return state;
        }
        boolean bl2 = ((class_2773)state.method_11654(WIRE_CONNECTION_NORTH)).method_27855();
        boolean bl3 = ((class_2773)state.method_11654(WIRE_CONNECTION_SOUTH)).method_27855();
        boolean bl4 = ((class_2773)state.method_11654(WIRE_CONNECTION_EAST)).method_27855();
        boolean bl5 = ((class_2773)state.method_11654(WIRE_CONNECTION_WEST)).method_27855();
        boolean bl6 = !bl2 && !bl3;
        boolean bl8 = bl7 = !bl4 && !bl5;
        if (!bl5 && bl6) {
            state = (class_2680)state.method_11657(WIRE_CONNECTION_WEST, (Comparable)class_2773.field_12689);
        }
        if (!bl4 && bl6) {
            state = (class_2680)state.method_11657(WIRE_CONNECTION_EAST, (Comparable)class_2773.field_12689);
        }
        if (!bl2 && bl7) {
            state = (class_2680)state.method_11657(WIRE_CONNECTION_NORTH, (Comparable)class_2773.field_12689);
        }
        if (!bl3 && bl7) {
            state = (class_2680)state.method_11657(WIRE_CONNECTION_SOUTH, (Comparable)class_2773.field_12689);
        }
        return state;
    }

    private class_2680 method_27843(class_1922 world, class_2680 state, class_2338 pos) {
        boolean bl = !world.method_8320(pos.method_10084()).method_26212(world, pos);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (((class_2773)state.method_11654((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction))).method_27855()) continue;
            class_2773 wireConnection = this.getRenderConnectionType(world, pos, direction, bl);
            state = (class_2680)state.method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)wireConnection);
        }
        return state;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11033) {
            return state;
        }
        if (direction == class_2350.field_11036) {
            return this.getPlacementState((class_1922)world, state, pos);
        }
        class_2773 wireConnection = this.getRenderConnectionType((class_1922)world, pos, direction);
        return wireConnection.method_27855() == ((class_2773)state.method_11654((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction))).method_27855() && !CopperPatinaBlock.isFullyConnected(state) ? (class_2680)state.method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)wireConnection) : this.getPlacementState((class_1922)world, (class_2680)((class_2680)this.dotState.method_11657((class_2769)POWER, (Comparable)((Integer)state.method_11654((class_2769)POWER)))).method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)wireConnection), pos);
    }

    private static boolean isFullyConnected(class_2680 state) {
        return ((class_2773)state.method_11654(WIRE_CONNECTION_NORTH)).method_27855() && ((class_2773)state.method_11654(WIRE_CONNECTION_SOUTH)).method_27855() && ((class_2773)state.method_11654(WIRE_CONNECTION_EAST)).method_27855() && ((class_2773)state.method_11654(WIRE_CONNECTION_WEST)).method_27855();
    }

    private static boolean isNotConnected(class_2680 state) {
        return !((class_2773)state.method_11654(WIRE_CONNECTION_NORTH)).method_27855() && !((class_2773)state.method_11654(WIRE_CONNECTION_SOUTH)).method_27855() && !((class_2773)state.method_11654(WIRE_CONNECTION_EAST)).method_27855() && !((class_2773)state.method_11654(WIRE_CONNECTION_WEST)).method_27855();
    }

    public void method_9517(class_2680 state, class_1936 world, class_2338 pos, int flags, int maxUpdateDepth) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2773 wireConnection = (class_2773)state.method_11654((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction));
            if (wireConnection == class_2773.field_12687 || world.method_8320((class_2338)mutable.method_25505((class_2382)pos, direction)).method_27852((class_2248)this)) continue;
            mutable.method_10098(class_2350.field_11033);
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (!blockState.method_27852(class_2246.field_10282)) {
                class_2338 blockPos = mutable.method_10093(direction.method_10153());
                class_2680 blockState2 = blockState.method_26191(direction.method_10153(), world.method_8320(blockPos), world, (class_2338)mutable, blockPos);
                CopperPatinaBlock.method_9611((class_2680)blockState, (class_2680)blockState2, (class_1936)world, (class_2338)mutable, (int)flags, (int)maxUpdateDepth);
            }
            mutable.method_25505((class_2382)pos, direction).method_10098(class_2350.field_11036);
            class_2680 blockState3 = world.method_8320((class_2338)mutable);
            if (blockState3.method_27852(class_2246.field_10282)) continue;
            class_2338 blockPos2 = mutable.method_10093(direction.method_10153());
            class_2680 blockState4 = blockState3.method_26191(direction.method_10153(), world.method_8320(blockPos2), world, (class_2338)mutable, blockPos2);
            CopperPatinaBlock.method_9611((class_2680)blockState3, (class_2680)blockState4, (class_1936)world, (class_2338)mutable, (int)flags, (int)maxUpdateDepth);
        }
    }

    private class_2773 getRenderConnectionType(class_1922 world, class_2338 pos, class_2350 direction) {
        return this.getRenderConnectionType(world, pos, direction, !world.method_8320(pos.method_10084()).method_26212(world, pos));
    }

    private class_2773 getRenderConnectionType(class_1922 world, class_2338 pos, class_2350 direction, boolean bl) {
        boolean bl2;
        class_2338 blockPos = pos.method_10093(direction);
        class_2680 blockState = world.method_8320(blockPos);
        if (bl && (bl2 = this.canRunOnTop(world, blockPos, blockState)) && CopperPatinaBlock.connectsTo(world.method_8320(blockPos.method_10084()))) {
            if (blockState.method_26206(world, blockPos, direction.method_10153())) {
                return class_2773.field_12686;
            }
            return class_2773.field_12689;
        }
        return !CopperPatinaBlock.connectsTo(blockState, direction) && (blockState.method_26212(world, blockPos) || !CopperPatinaBlock.connectsTo(world.method_8320(blockPos.method_10074()))) ? class_2773.field_12687 : class_2773.field_12689;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (!Config.getBool(ConfigValues.COPPER_PATINA)) {
            return false;
        }
        class_2338 blockPos = pos.method_10074();
        class_2680 blockState = world.method_8320(blockPos);
        return this.canRunOnTop((class_1922)world, blockPos, blockState);
    }

    private boolean canRunOnTop(class_1922 world, class_2338 pos, class_2680 floor) {
        return floor.method_26206(world, pos, class_2350.field_11036) || floor.method_27852(class_2246.field_10312);
    }

    private void update(class_1937 world, class_2338 pos, class_2680 state) {
        int i = this.getReceivedRedstonePower(world, pos);
        if (!Config.getBool(ConfigValues.COPPER_PATINA)) {
            i = 0;
        }
        if ((Integer)state.method_11654((class_2769)POWER) != i) {
            if (world.method_8320(pos) == state) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(i)), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            for (class_2350 direction : class_2350.values()) {
                set.add(pos.method_10093(direction));
            }
            for (class_2338 blockPos : set) {
                world.method_8452(blockPos, (class_2248)this);
            }
        }
    }

    private int getReceivedRedstonePower(class_1937 world, class_2338 pos) {
        this.wiresGivePower = false;
        int i = 0;
        for (class_2350 dir : field_23157) {
            class_2338 posi = pos.method_10093(dir);
            class_2680 state = world.method_8320(posi);
            int j = 0;
            if (!state.method_27852(class_2246.field_10091)) {
                j = world.method_49808(posi, dir);
            }
            if (j >= 15) {
                i = 15;
                break;
            }
            if (j <= i) continue;
            i = j;
        }
        this.wiresGivePower = true;
        int j = 0;
        if (i < 15) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 blockPos = pos.method_10093(direction);
                class_2680 blockState = world.method_8320(blockPos);
                j = Math.max(j, this.increasePower(blockState));
                class_2338 blockPos2 = pos.method_10084();
                if (blockState.method_26212((class_1922)world, blockPos) && !world.method_8320(blockPos2).method_26212((class_1922)world, blockPos2)) {
                    j = Math.max(j, this.increasePower(world.method_8320(blockPos.method_10084())));
                    continue;
                }
                if (blockState.method_26212((class_1922)world, blockPos)) continue;
                j = Math.max(j, this.increasePower(world.method_8320(blockPos.method_10074())));
            }
            return Math.max(i, j - 2);
        }
        return Math.max(i, j - 2);
    }

    private int increasePower(class_2680 state) {
        return state.method_27852((class_2248)AdditionalBlocks.COPPER_PATINA) ? (Integer)state.method_11654((class_2769)POWER) : 0;
    }

    private void updateNeighbors(class_1937 world, class_2338 pos) {
        if (world.method_8320(pos).method_27852((class_2248)this)) {
            world.method_8452(pos, (class_2248)this);
            for (class_2350 direction : class_2350.values()) {
                world.method_8452(pos.method_10093(direction), (class_2248)this);
            }
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!oldState.method_27852(state.method_26204()) && !world.field_9236) {
            this.update(world, pos, state);
            for (class_2350 direction : class_2350.class_2353.field_11064) {
                world.method_8452(pos.method_10093(direction), (class_2248)this);
            }
            this.updateOffsetNeighbors(world, pos);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!moved && !state.method_27852(newState.method_26204())) {
            super.method_9536(state, world, pos, newState, moved);
            if (!world.field_9236) {
                for (class_2350 direction : class_2350.values()) {
                    world.method_8452(pos.method_10093(direction), (class_2248)this);
                }
                this.update(world, pos, state);
                this.updateOffsetNeighbors(world, pos);
            }
        }
    }

    private void updateOffsetNeighbors(class_1937 world, class_2338 pos) {
        for (class_2350 direction2 : class_2350.class_2353.field_11062) {
            this.updateNeighbors(world, pos.method_10093(direction2));
        }
        for (class_2350 direction2 : class_2350.class_2353.field_11062) {
            class_2338 blockPos = pos.method_10093(direction2);
            if (world.method_8320(blockPos).method_26212((class_1922)world, blockPos)) {
                this.updateNeighbors(world, blockPos.method_10084());
                continue;
            }
            this.updateNeighbors(world, blockPos.method_10074());
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (!world.field_9236) {
            if (state.method_26184((class_4538)world, pos)) {
                this.update(world, pos, state);
            } else {
                CopperPatinaBlock.method_9497((class_2680)state, (class_1937)world, (class_2338)pos);
                world.method_8650(pos, false);
            }
        }
    }

    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return this.wiresGivePower && !state.method_27852(class_2246.field_10091) ? state.method_26195(world, pos, direction) : 0;
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        if (this.wiresGivePower && direction != class_2350.field_11033) {
            int i = (Integer)state.method_11654((class_2769)POWER);
            if (i == 0 || state.method_27852(class_2246.field_10091)) {
                return 0;
            }
            return direction != class_2350.field_11036 && !((class_2773)this.getPlacementState(world, state, pos).method_11654((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction.method_10153()))).method_27855() ? 0 : i;
        }
        return 0;
    }

    protected static boolean connectsTo(class_2680 state) {
        return CopperPatinaBlock.connectsTo(state, null);
    }

    protected static boolean connectsTo(class_2680 state, @Nullable class_2350 dir) {
        if (state.method_27852((class_2248)AdditionalBlocks.COPPER_PATINA)) {
            return true;
        }
        if (state.method_27852(class_2246.field_10091)) {
            return false;
        }
        if (state.method_27852(class_2246.field_10450)) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)class_2462.field_11177);
            return direction == dir || direction.method_10153() == dir;
        }
        if (state.method_27852(class_2246.field_10282)) {
            return dir == state.method_11654((class_2769)class_2426.field_10927);
        }
        return state.method_26219() && dir != null;
    }

    public boolean method_9506(class_2680 state) {
        return this.wiresGivePower;
    }

    public static int getWireColor(int powerLevel) {
        class_243 vec3d = COLORS[powerLevel];
        return class_3532.method_15353((float)((float)vec3d.method_10216()), (float)((float)vec3d.method_10214()), (float)((float)vec3d.method_10215()));
    }

    private void addPoweredParticles(class_1937 world, Random random, class_2338 pos, class_243 color, class_2350 direction, class_2350 direction2, float f, float g) {
    }

    public void animateTick(class_2680 state, class_1937 world, class_2338 pos, Random random) {
        int i = (Integer)state.method_11654((class_2769)POWER);
        if (i != 0) {
            block4: for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2773 wireConnection = (class_2773)state.method_11654((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction));
                switch (wireConnection) {
                    case field_12686: {
                        this.addPoweredParticles(world, random, pos, COLORS[i], direction, class_2350.field_11036, -0.5f, 0.5f);
                    }
                    case field_12689: {
                        this.addPoweredParticles(world, random, pos, COLORS[i], class_2350.field_11033, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.addPoweredParticles(world, random, pos, COLORS[i], class_2350.field_11033, direction, 0.0f, 0.3f);
            }
        }
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(WIRE_CONNECTION_NORTH, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_SOUTH)))).method_11657(WIRE_CONNECTION_EAST, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_WEST)))).method_11657(WIRE_CONNECTION_SOUTH, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_NORTH)))).method_11657(WIRE_CONNECTION_WEST, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_EAST)));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(WIRE_CONNECTION_NORTH, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_EAST)))).method_11657(WIRE_CONNECTION_EAST, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_SOUTH)))).method_11657(WIRE_CONNECTION_SOUTH, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_WEST)))).method_11657(WIRE_CONNECTION_WEST, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_NORTH)));
            }
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(WIRE_CONNECTION_NORTH, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_WEST)))).method_11657(WIRE_CONNECTION_EAST, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_NORTH)))).method_11657(WIRE_CONNECTION_SOUTH, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_EAST)))).method_11657(WIRE_CONNECTION_WEST, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_SOUTH)));
            }
        }
        return state;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657(WIRE_CONNECTION_NORTH, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_SOUTH)))).method_11657(WIRE_CONNECTION_SOUTH, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_NORTH)));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657(WIRE_CONNECTION_EAST, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_WEST)))).method_11657(WIRE_CONNECTION_WEST, (Comparable)((class_2773)state.method_11654(WIRE_CONNECTION_EAST)));
            }
        }
        return super.method_9569(state, mirror);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WIRE_CONNECTION_NORTH, WIRE_CONNECTION_EAST, WIRE_CONNECTION_SOUTH, WIRE_CONNECTION_WEST, POWER});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!player.method_31549().field_7476) {
            return class_1269.field_5811;
        }
        if (CopperPatinaBlock.isFullyConnected(state) || CopperPatinaBlock.isNotConnected(state)) {
            class_2680 blockState = CopperPatinaBlock.isFullyConnected(state) ? this.method_9564() : this.dotState;
            blockState = (class_2680)blockState.method_11657((class_2769)POWER, (Comparable)((Integer)state.method_11654((class_2769)POWER)));
            if ((blockState = this.getPlacementState((class_1922)world, blockState, pos)) != state) {
                world.method_8652(pos, blockState, 3);
                this.updateForNewState(world, pos, state, blockState);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    private void updateForNewState(class_1937 world, class_2338 pos, class_2680 oldState, class_2680 newState) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 blockPos = pos.method_10093(direction);
            if (((class_2773)oldState.method_11654((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction))).method_27855() == ((class_2773)newState.method_11654((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction))).method_27855() || !world.method_8320(blockPos).method_26212((class_1922)world, blockPos)) continue;
            world.method_8508(blockPos, newState.method_26204(), direction.method_10153());
        }
    }
}

