/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.behaviour;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dqu.additionaladditions.AdditionalAdditions;
import dqu.additionaladditions.behaviour.BehaviourValues;
import dqu.additionaladditions.config.ConfigProperty;
import dqu.additionaladditions.config.value.BooleanConfigValue;
import dqu.additionaladditions.config.value.FloatConfigValue;
import dqu.additionaladditions.config.value.IntegerConfigValue;
import dqu.additionaladditions.config.value.ListConfigValue;
import dqu.additionaladditions.config.value.StringConfigValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class BehaviourManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private Map<class_2960, ConfigProperty> behaviours = ImmutableMap.of();
    public static BehaviourManager INSTANCE = new BehaviourManager();
    public static int loads;

    public BehaviourManager() {
        super(GSON, "behaviour");
    }

    public String method_22322() {
        return "behaviour";
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profilerFiller) {
        HashMap<class_2960, ConfigProperty> hashMap = new HashMap<class_2960, ConfigProperty>();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 resourceLocation = entry.getKey();
            if (!resourceLocation.method_12836().equals("additionaladditions")) continue;
            JsonElement jsonElement = entry.getValue();
            List<ConfigProperty> properties = BehaviourManager.loadBehaviour(resourceLocation, jsonElement);
            ListConfigValue listConfigValue = new ListConfigValue().putAll(properties);
            hashMap.put(resourceLocation, new ConfigProperty(resourceLocation.method_12832(), listConfigValue));
        }
        this.behaviours = ImmutableMap.copyOf(hashMap);
        AdditionalAdditions.LOGGER.info("[{}] Loaded {} behaviours", (Object)"additionaladditions", (Object)this.behaviours.size());
        ++loads;
    }

    private static List<ConfigProperty> loadBehaviour(class_2960 resourceLocation, JsonElement jsonElement) {
        JsonObject object = jsonElement.getAsJsonObject();
        ArrayList<ConfigProperty> properties = new ArrayList<ConfigProperty>();
        for (Map.Entry entry : object.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            BehaviourValues.getByName(key).ifPresentOrElse(behaviour -> {
                switch (behaviour.getType()) {
                    case STRING: {
                        properties.add(new ConfigProperty(key, new StringConfigValue(value.getAsString())));
                        break;
                    }
                    case BOOLEAN: {
                        properties.add(new ConfigProperty(key, new BooleanConfigValue(value.getAsBoolean())));
                        break;
                    }
                    case INTEGER: {
                        properties.add(new ConfigProperty(key, new IntegerConfigValue(value.getAsInt())));
                        break;
                    }
                    case FLOAT: {
                        properties.add(new ConfigProperty(key, new FloatConfigValue(Float.valueOf(value.getAsFloat()))));
                        break;
                    }
                    default: {
                        AdditionalAdditions.LOGGER.warn("[{}] Incorrect property: {} in behaviour {}. This shouldn't happen, please report.", new Object[]{"additionaladditions", key, resourceLocation.method_12832()});
                    }
                }
            }, () -> AdditionalAdditions.LOGGER.warn("[{}] Unknown property: {} in behaviour {}.", new Object[]{"additionaladditions", key, resourceLocation.method_12832()}));
        }
        return properties;
    }

    public ConfigProperty getBehaviour(String name) {
        return this.behaviours.get(new class_2960("additionaladditions", name));
    }

    public <T> T getBehaviourValue(String name, BehaviourValues values) {
        String key;
        ConfigProperty property = this.getBehaviour(name);
        if (property == null) {
            return null;
        }
        ListConfigValue list = (ListConfigValue)property.value();
        if (list.get(key = values.getName()) == null || list.get(key).value() == null) {
            return null;
        }
        return (T)list.get(key).value().getValue();
    }

    public Map<class_2960, ConfigProperty> getBehaviours() {
        return this.behaviours;
    }

    public class_2960 getFabricId() {
        return new class_2960("additionaladditions", "behaviour");
    }
}

