/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.event;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.schmarrn.lighty.ModeLoader;
import dev.schmarrn.lighty.api.LightyMode;
import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.event.BufferHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_6854;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class Compute {
    private static final int INITIAL_HASHSET_CAPACITY = 550;
    private static HashSet<class_4076> toBeUpdated = new HashSet(550);
    private static HashSet<class_4076> toBeRemoved = new HashSet(550);
    private static final Map<class_4076, BufferHolder> cachedBuffers = new HashMap<class_4076, BufferHolder>();
    private static class_1923 playerPos = null;
    private static int computationDistance = Math.min(Config.getOverlayDistance(), (Integer)class_310.method_1551().field_1690.method_42503().method_41753());

    private static boolean outOfRange(class_4076 pos) {
        int computationDistanceSquared = computationDistance * computationDistance;
        if (playerPos == null) {
            return true;
        }
        int sqX = (pos.method_18674() - Compute.playerPos.field_9181) * (pos.method_18674() - Compute.playerPos.field_9181);
        int sqZ = (pos.method_18687() - Compute.playerPos.field_9180) * (pos.method_18687() - Compute.playerPos.field_9180);
        return sqX > computationDistanceSquared || sqZ > computationDistanceSquared;
    }

    public static void clear() {
        toBeUpdated = new HashSet(550);
        cachedBuffers.forEach((sectionPos, vertexBuffer) -> vertexBuffer.close());
        cachedBuffers.clear();
        computationDistance = Math.min(Config.getOverlayDistance(), (Integer)class_310.method_1551().field_1690.method_42503().method_41753());
    }

    public static void updateSubChunk(class_4076 pos) {
        if (Compute.outOfRange(pos)) {
            return;
        }
        toBeUpdated.add(pos);
    }

    private static BufferHolder buildChunk(LightyMode mode, class_4076 chunkPos, class_287 builder, class_638 world) {
        mode.beforeCompute(builder);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    class_2338 pos = chunkPos.method_19767().method_10069(x, y, z);
                    mode.compute(world, pos, builder);
                }
            }
        }
        BufferHolder buffer = cachedBuffers.get(chunkPos);
        if (buffer == null) {
            buffer = new BufferHolder();
        }
        buffer.upload(builder.method_1326());
        mode.afterCompute();
        return buffer;
    }

    public static void computeCache(class_310 client) {
        LightyMode mode = ModeLoader.getCurrentMode();
        if (mode == null) {
            return;
        }
        class_638 world = client.field_1687;
        if (client.field_1724 == null || world == null) {
            return;
        }
        playerPos = new class_1923(client.field_1724.method_24515());
        cachedBuffers.forEach((sectionPos, bufferHolder) -> {
            if (Compute.outOfRange(sectionPos)) {
                toBeRemoved.add((class_4076)sectionPos);
            }
        });
        HashSet<class_4076> removeFromToBeUpdated = new HashSet<class_4076>(550);
        for (class_4076 sectionPos2 : toBeUpdated) {
            if (Compute.outOfRange(sectionPos2)) {
                toBeRemoved.add(sectionPos2);
                continue;
            }
            removeFromToBeUpdated.add(sectionPos2);
            cachedBuffers.compute(sectionPos2, (pos, vertexBuffer) -> {
                if (vertexBuffer != null) {
                    vertexBuffer.close();
                }
                return Compute.buildChunk(mode, pos, class_289.method_1348().method_1349(), world);
            });
        }
        for (class_4076 pos2 : removeFromToBeUpdated) {
            toBeUpdated.remove(pos2);
        }
        for (class_4076 sectionPos2 : toBeRemoved) {
            toBeUpdated.remove(sectionPos2);
            BufferHolder buf = cachedBuffers.remove(sectionPos2);
            if (buf == null) continue;
            buf.close();
        }
        toBeRemoved = new HashSet(550);
    }

    public static void render(@Nullable class_4604 frustum, class_4587 matrixStack, Matrix4f projectionMatrix) {
        LightyMode mode = ModeLoader.getCurrentMode();
        if (mode == null) {
            return;
        }
        if (frustum == null) {
            return;
        }
        if (playerPos == null) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        mode.beforeRendering();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        matrixStack.method_22903();
        matrixStack.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        Matrix4f positionMatrix = matrixStack.method_23760().method_23761();
        class_5944 shader = RenderSystem.getShader();
        float renderDistance = class_310.method_1551().field_1773.method_3193() * 16.0f * 4012.0f;
        float fogStart = renderDistance - class_3532.method_15363((float)(renderDistance / 10.0f), (float)4.0f, (float)64.0f);
        float oldFogStart = RenderSystem.getShaderFogStart();
        float oldFogEnd = RenderSystem.getShaderFogEnd();
        class_6854 oldFogShape = RenderSystem.getShaderFogShape();
        RenderSystem.setShaderFogStart((float)fogStart);
        RenderSystem.setShaderFogEnd((float)renderDistance);
        RenderSystem.setShaderFogShape((class_6854)class_6854.field_36351);
        for (int x = -computationDistance + 1; x < computationDistance; ++x) {
            for (int z = -computationDistance + 1; z < computationDistance; ++z) {
                class_1923 chunkPos = new class_1923(Compute.playerPos.field_9181 + x, Compute.playerPos.field_9180 + z);
                for (int i = 0; i < world.method_32890(); ++i) {
                    class_4076 chunkSection = class_4076.method_18681((class_1923)chunkPos, (int)(world.method_32891() + i));
                    if (!frustum.method_23093(new class_238(chunkSection.method_19767().method_10069(-1, -1, -1), chunkSection.method_19767().method_10069(16, 16, 16)))) continue;
                    if (cachedBuffers.containsKey(chunkSection)) {
                        BufferHolder cachedBuffer = cachedBuffers.get(chunkSection);
                        if (!cachedBuffer.isValid()) {
                            toBeUpdated.add(chunkSection);
                            continue;
                        }
                        cachedBuffer.draw(positionMatrix, projectionMatrix, shader);
                        continue;
                    }
                    toBeUpdated.add(chunkSection);
                }
            }
        }
        RenderSystem.setShaderFogStart((float)oldFogStart);
        RenderSystem.setShaderFogEnd((float)oldFogEnd);
        RenderSystem.setShaderFogShape((class_6854)oldFogShape);
        matrixStack.method_22909();
        mode.afterRendering();
    }

    private Compute() {
    }
}

