/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.config;

import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.UtilDefinition;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.minecraft.class_2960;

public class Config {
    private static final String PATH = UtilDefinition.INSTANCE.getConfigDir().toString() + "/lighty.config";
    private final Properties properties = new Properties();
    private static Config config;
    private static final String LAST_USED_MODE = "lighty.last_used_mode";
    private static final String SKY_THRESHOLD = "lighty.sky_threshold";
    private static final String BLOCK_THRESHOLD = "lighty.block_threshold";
    private static final String OVERLAY_DISTANCE = "lighty.overlay_distance";
    private static final String OVERLAY_BRIGHTNESS = "lighty.overlay_brightness";
    private static final String SHOW_SAFE = "lighty.show_safe";

    private Config() {
        try (FileReader reader = new FileReader(PATH);){
            this.properties.load(reader);
            this.properties.putIfAbsent(LAST_USED_MODE, "lighty:carpet_mode");
            this.properties.putIfAbsent(SKY_THRESHOLD, "0");
            this.properties.putIfAbsent(BLOCK_THRESHOLD, "0");
            this.properties.putIfAbsent(OVERLAY_DISTANCE, "2");
            this.properties.putIfAbsent(OVERLAY_BRIGHTNESS, "10");
            this.properties.putIfAbsent(SHOW_SAFE, String.valueOf(true));
        }
        catch (FileNotFoundException e) {
            Lighty.LOGGER.warn("No Lighty config found at {}, loading defaults and saving config file.", (Object)PATH);
            this.properties.setProperty(LAST_USED_MODE, "lighty:carpet_mode");
            this.properties.setProperty(SKY_THRESHOLD, "0");
            this.properties.setProperty(BLOCK_THRESHOLD, "0");
            this.properties.setProperty(OVERLAY_DISTANCE, "2");
            this.properties.setProperty(OVERLAY_BRIGHTNESS, "10");
            this.properties.setProperty(SHOW_SAFE, String.valueOf(true));
            this.write();
        }
        catch (IOException e) {
            Lighty.LOGGER.error("Error while reading from Lighty config at {}: {}", (Object)PATH, (Object)e);
        }
    }

    private void write() {
        try (FileWriter writer = new FileWriter(PATH);){
            this.properties.store(writer, null);
        }
        catch (IOException e) {
            Lighty.LOGGER.error("Error while writing to Lighty config at {}: {}", (Object)PATH, (Object)e);
        }
    }

    public static int getSkyThreshold() {
        return Integer.parseInt(Config.config.properties.getProperty(SKY_THRESHOLD, "0"));
    }

    public static int getBlockThreshold() {
        return Integer.parseInt(Config.config.properties.getProperty(BLOCK_THRESHOLD, "0"));
    }

    public static int getOverlayDistance() {
        return Integer.parseInt(Config.config.properties.getProperty(OVERLAY_DISTANCE, "2"));
    }

    public static int getOverlayBrightness() {
        return Integer.parseInt(Config.config.properties.getProperty(OVERLAY_BRIGHTNESS, "10"));
    }

    public static boolean getShowSafe() {
        return Boolean.parseBoolean(Config.config.properties.getProperty(SHOW_SAFE, String.valueOf(true)));
    }

    public static class_2960 getLastUsedMode() {
        return new class_2960(Config.config.properties.getProperty(LAST_USED_MODE, "lighty:carpet_mode"));
    }

    public static void setLastUsedMode(class_2960 id) {
        Config.config.properties.setProperty(LAST_USED_MODE, id.toString());
        config.write();
    }

    public static void setSkyThreshold(int i) {
        Config.config.properties.setProperty(SKY_THRESHOLD, String.valueOf(i));
        config.write();
    }

    public static void setBlockThreshold(int i) {
        Config.config.properties.setProperty(BLOCK_THRESHOLD, String.valueOf(i));
        config.write();
    }

    public static void setOverlayDistance(int i) {
        Config.config.properties.setProperty(OVERLAY_DISTANCE, String.valueOf(i));
        config.write();
    }

    public static void setOverlayBrightness(int i) {
        Config.config.properties.setProperty(OVERLAY_BRIGHTNESS, String.valueOf(i));
        config.write();
    }

    public static void setShowSafe(boolean b) {
        Config.config.properties.setProperty(SHOW_SAFE, String.valueOf(b));
        config.write();
    }

    public static void init() {
        config = new Config();
    }
}

