/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.util;

import dynamic_fps.impl.service.ModCompat;
import dynamic_fps.impl.service.Platform;
import dynamic_fps.impl.util.Logging;
import java.util.Arrays;
import java.util.Optional;

public class ModCompatHelper {
    public static void init() {
        ModCompatHelper.fixFastloadSoftLock();
    }

    private static void fixFastloadSoftLock() {
        Optional<String> optional = Platform.getInstance().getModVersion("fastload");
        if (optional.isEmpty()) {
            return;
        }
        String[] parts = optional.get().split("\\.");
        int[] version = Arrays.stream(parts).mapToInt(Integer::parseInt).toArray();
        if (version.length < 3) {
            Logging.getLogger().warn("Unable to parse Fastload version: {}!", (Object)optional.get());
            return;
        }
        if (version[0] <= 3 && (version[0] != 3 || version[1] <= 4 && (version[1] != 4 || version[2] <= 0))) {
            ModCompat.getInstance().getOptedOutScreens().add("io.github.bumblesoftware.fastload.client.BuildingTerrainScreen");
        }
    }
}

