/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.autoclicker;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.mikey.autoclicker.Config;
import pro.mikey.autoclicker.Holding;
import pro.mikey.autoclicker.Language;
import pro.mikey.autoclicker.OptionsScreen;

public class AutoClicker
implements ModInitializer {
    public static final String MOD_ID = "autoclicker-fabric";
    public static final Logger LOGGER = LogManager.getLogger((String)"autoclicker-fabric");
    public static final class_304 rightClickToggle = new class_304("keybinding.open-gui", 79, "category.autoclicker-fabric");
    private static final class_304 toggleHolding = new class_304("keybinding.toggle-hold", 73, "category.autoclicker-fabric");
    private static final Path CONFIG_DIR = Paths.get(class_310.method_1551().field_1697.getPath() + "/config", new String[0]);
    private static final Path CONFIG_FILE = Paths.get(CONFIG_DIR + "/auto-clicker-fabric.json", new String[0]);
    public static Holding.AttackHolding leftHolding;
    public static Holding rightHolding;
    public static Holding jumpHolding;
    private static AutoClicker INSTANCE;
    private boolean isActive = false;
    private Config config = new Config(new Config.LeftMouseConfig(false, false, 0, false, false), new Config.RightMouseConfig(false, false, 0), new Config.JumpConfig(false, false, 0));

    public AutoClicker() {
        INSTANCE = this;
    }

    public static AutoClicker getInstance() {
        return INSTANCE;
    }

    public void onInitialize() {
        LOGGER.info("Auto Clicker Initialised");
        ClientTickEvents.END_CLIENT_TICK.register(this::clientTickEvent);
        KeyBindingHelper.registerKeyBinding((class_304)toggleHolding);
        KeyBindingHelper.registerKeyBinding((class_304)rightClickToggle);
        ClientLifecycleEvents.CLIENT_STARTED.register(this::clientReady);
        HudRenderCallback.EVENT.register(this::RenderGameOverlayEvent);
    }

    private void clientReady(class_310 client) {
        if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
            try {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
                Files.createFile(CONFIG_FILE, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.saveConfig();
        } else {
            try {
                FileReader json = new FileReader(CONFIG_FILE.toFile());
                Config config = (Config)new Gson().fromJson((Reader)json, Config.class);
                json.close();
                if (config != null && config.getJump() != null) {
                    this.config = config;
                }
            }
            catch (JsonIOException | IOException e) {
                e.printStackTrace();
            }
        }
        leftHolding = new Holding.AttackHolding(client.field_1690.field_1886, this.config.getLeftClick());
        rightHolding = new Holding(client.field_1690.field_1904, this.config.getRightClick());
        jumpHolding = new Holding(client.field_1690.field_1903, this.config.getJump());
    }

    public void saveConfig() {
        try {
            FileWriter writer = new FileWriter(CONFIG_FILE.toFile());
            new Gson().toJson((Object)this.config, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void RenderGameOverlayEvent(class_332 drawContext, float delta) {
        if (!leftHolding.isActive() && !rightHolding.isActive() && !jumpHolding.isActive() || !this.isActive) {
            return;
        }
        int y = 10;
        if (leftHolding.isActive()) {
            drawContext.method_51439(class_310.method_1551().field_1772, Language.HUD_HOLDING.getText(class_1074.method_4662((String)leftHolding.getKey().method_1431(), (Object[])new Object[0])), 10, y, 0xFFFFFF, true);
            y += 15;
        }
        if (rightHolding.isActive()) {
            drawContext.method_51439(class_310.method_1551().field_1772, Language.HUD_HOLDING.getText(class_1074.method_4662((String)rightHolding.getKey().method_1431(), (Object[])new Object[0])), 10, y, 0xFFFFFF, true);
            y += 15;
        }
        if (jumpHolding.isActive()) {
            drawContext.method_51439(class_310.method_1551().field_1772, Language.HUD_HOLDING.getText(class_1074.method_4662((String)jumpHolding.getKey().method_1431(), (Object[])new Object[0])), 10, y, 0xFFFFFF, true);
        }
    }

    private void clientTickEvent(class_310 mc) {
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        if (this.isActive) {
            if (leftHolding.isActive()) {
                this.handleActiveHolding(mc, leftHolding);
            }
            if (rightHolding.isActive()) {
                this.handleActiveHolding(mc, rightHolding);
            }
            if (jumpHolding.isActive()) {
                this.handleActiveHolding(mc, jumpHolding);
            }
        }
        this.keyInputEvent(mc);
    }

    private void handleActiveHolding(class_310 mc, Holding key) {
        assert (mc.field_1724 != null);
        if (!key.isActive()) {
            return;
        }
        if (key.isSpamming()) {
            if (key.getSpeed() > 0) {
                if (key.getTimeout() <= 1) {
                    key.getKey().method_23481(key.getTimeout() == 1);
                    if (key.getKey().method_1434()) {
                        this.attemptMobAttack(mc, key);
                    }
                    if (key.getTimeout() <= 0) {
                        key.resetTimeout();
                    }
                }
                key.decreaseTimeout();
            } else {
                key.getKey().method_23481(!key.getKey().method_1434());
                if (key.getKey().method_1434()) {
                    this.attemptMobAttack(mc, key);
                }
            }
            return;
        }
        if (key.isRespectCooldown()) {
            if (key instanceof Holding.AttackHolding && ((Holding.AttackHolding)key).isMobMode() && !this.isPlayerLookingAtMob(mc)) {
                if (key.getKey().method_1434()) {
                    key.getKey().method_23481(false);
                }
                return;
            }
            if (mc.field_1724.method_7261(0.0f) == 1.0f) {
                key.getKey().method_23481(true);
                this.attemptMobAttack(mc, key);
            } else {
                key.getKey().method_23481(false);
            }
        } else {
            key.getKey().method_23481(true);
        }
    }

    private void attemptMobAttack(class_310 mc, Holding key) {
        if (key.getKey() != leftHolding.getKey()) {
            return;
        }
        class_239 rayTrace = mc.field_1765;
        if (rayTrace instanceof class_3966 && mc.field_1761 != null) {
            mc.field_1761.method_2918((class_1657)mc.field_1724, ((class_3966)rayTrace).method_17782());
        }
    }

    private boolean isPlayerLookingAtMob(class_310 mc) {
        class_239 rayTrace = mc.field_1765;
        return rayTrace instanceof class_3966 && ((class_3966)rayTrace).method_17782() instanceof class_1309;
    }

    private void keyInputEvent(class_310 mc) {
        assert (mc.field_1724 != null);
        while (toggleHolding.method_1436()) {
            this.isActive = !this.isActive;
            mc.field_1724.method_7353((class_2561)(this.isActive ? Language.MSG_HOLDING_KEYS : Language.MSG_RELEASED_KEYS).getText().method_27692(this.isActive ? class_124.field_1060 : class_124.field_1061), true);
            if (this.isActive) continue;
            leftHolding.getKey().method_23481(false);
            rightHolding.getKey().method_23481(false);
            jumpHolding.getKey().method_23481(false);
        }
        while (rightClickToggle.method_1436()) {
            mc.method_1507((class_437)new OptionsScreen());
        }
    }
}

