/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.handlers;

import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import earth.terrarium.adastra.common.handlers.base.SpaceStation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class SpaceStationHandler
extends SaveHandler {
    private final Map<UUID, Set<SpaceStation>> spaceStationData = new HashMap<UUID, Set<SpaceStation>>();

    public void loadData(class_2487 tag) {
        tag.method_10541().forEach(id -> {
            class_2499 stationsTag = tag.method_10554(id, 10);
            HashSet stations = new HashSet();
            stationsTag.forEach(stationTag -> {
                class_2487 stationCompoundTag = (class_2487)stationTag;
                class_5250 name = class_2561.class_2562.method_10877((String)stationCompoundTag.method_10558("Name"));
                class_1923 position = new class_1923(stationCompoundTag.method_10537("Position"));
                stations.add(new SpaceStation(position, (class_2561)name));
            });
            this.spaceStationData.put(UUID.fromString(id), stations);
        });
    }

    public void saveData(class_2487 tag) {
        this.spaceStationData.forEach((id, stations) -> {
            class_2499 ownerTag = new class_2499();
            for (SpaceStation station : stations) {
                class_2487 stationsTag = new class_2487();
                stationsTag.method_10582("Name", class_2561.class_2562.method_10867((class_2561)station.name()));
                stationsTag.method_10544("Position", station.position().method_8324());
                ownerTag.add((Object)stationsTag);
            }
            tag.method_10566(id.toString(), (class_2520)ownerTag);
        });
    }

    public static SpaceStationHandler read(class_3218 level) {
        return (SpaceStationHandler)SpaceStationHandler.read((class_26)level.method_17983(), SpaceStationHandler::new, (String)"adastra_space_station_data");
    }

    public static Map<UUID, Set<SpaceStation>> getAllSpaceStations(class_3218 level) {
        return SpaceStationHandler.read((class_3218)level).spaceStationData;
    }

    public boolean method_79() {
        return true;
    }

    public static void constructSpaceStation(class_3222 player, class_3218 level, class_2561 name) {
        Map<UUID, Set<SpaceStation>> data = SpaceStationHandler.read((class_3218)level).spaceStationData;
        Set stations = data.computeIfAbsent(player.method_5667(), k -> new HashSet());
        stations.add(new SpaceStation(player.method_31476(), name));
    }

    public static boolean isInSpaceStation(class_3222 player, class_3218 level) {
        for (Set<SpaceStation> stations : SpaceStationHandler.read((class_3218)level).spaceStationData.values()) {
            for (SpaceStation station : stations) {
                if (station.position().method_24022(player.method_31476()) > 2) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<SpaceStation> getOwnedSpaceStations(class_3222 player, class_3218 level) {
        return SpaceStationHandler.getOwnedSpaceStations(player.method_5667(), level);
    }

    public static Set<SpaceStation> getOwnedSpaceStations(UUID id, class_3218 level) {
        return SpaceStationHandler.read((class_3218)level).spaceStationData.getOrDefault(id, Set.of());
    }
}

