/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.WaterPumpMenu;
import earth.terrarium.adastra.common.registry.ModParticleTypes;
import earth.terrarium.adastra.common.utils.ModUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidBlock;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.ExtractOnlyFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedBlockFluidContainer;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2400;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;

public class WaterPumpBlockEntity
extends EnergyContainerMachineBlockEntity
implements BotariumFluidBlock<WrappedBlockFluidContainer> {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY), new ConfigurationEntry(ConfigurationType.FLUID, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_FLUID));
    private WrappedBlockFluidContainer fluidContainer;

    public WaterPumpBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, 1);
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new WaterPumpMenu(id, inventory, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachineConfig.deshTierEnergyCapacity, MachineConfig.deshTierMaxEnergyInOut));
        return this.energyContainer;
    }

    public WrappedBlockFluidContainer getFluidContainer() {
        if (this.fluidContainer != null) {
            return this.fluidContainer;
        }
        this.fluidContainer = new WrappedBlockFluidContainer((class_2586)this, (FluidContainer)new ExtractOnlyFluidContainer(i -> FluidConstants.fromMillibuckets((long)MachineConfig.deshTierFluidCapacity), 1, (tank, holder) -> holder.is(class_3486.field_15517)));
        return this.fluidContainer;
    }

    @Override
    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        if (!this.canFunction()) {
            return;
        }
        if (this.canPump(pos, this.energyContainer)) {
            this.pump(level, this.energyContainer);
        }
    }

    private boolean canPump(class_2338 pos, WrappedBlockEnergyContainer energyStorage) {
        if (!this.level().method_8316(pos.method_10074()).method_39360((class_3611)class_3612.field_15910)) {
            return false;
        }
        if (energyStorage.internalExtract(MachineConfig.waterPumpEnergyPerTick, true) < MachineConfig.waterPumpEnergyPerTick) {
            return false;
        }
        return this.fluidContainer.getFirstFluid().getFluidAmount() < this.fluidContainer.getTankCapacity(0);
    }

    private void pump(class_3218 level, WrappedBlockEnergyContainer energyStorage) {
        energyStorage.internalExtract(MachineConfig.waterPumpEnergyPerTick, false);
        this.fluidContainer.internalInsert(FluidHolder.ofMillibuckets((class_3611)class_3612.field_15910, (long)FluidConstants.fromMillibuckets((long)MachineConfig.waterPumpFluidGenerationPerTick)), false);
        ModUtils.sendParticles(level, (class_2400)ModParticleTypes.OXYGEN_BUBBLE.get(), (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() - 0.5, (double)this.method_11016().method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.01);
    }

    @Override
    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pullEnergyNearby(this, pos, this.getEnergyStorage().maxInsert(), sideConfig.get(0), filter);
        TransferUtils.pushFluidNearby(this, pos, this.getFluidContainer(), FluidConstants.fromMillibuckets((long)MachineConfig.waterPumpFluidGenerationPerTick), 0, sideConfig.get(1), filter);
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return new int[0];
    }
}

