/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.client.AdAstraClient;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.GravityNormalizerMenu;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.adastra.common.utils.floodfill.FloodFill3D;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class GravityNormalizerBlockEntity
extends EnergyContainerMachineBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY));
    private final Set<class_2338> lastDistributedBlocks = new HashSet<class_2338>();
    private long energyPerTick;
    private int distributedBlocksCount;
    private int shutDownTicks;
    private int limit = MachineConfig.maxDistributionBlocks;
    private boolean shouldSyncPositions;
    private float targetGravity = 1.0f;
    private float animation;
    private float lastAnimation;

    public GravityNormalizerBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, 1);
    }

    @Override
    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("LastDistributedBlocks")) {
            this.lastDistributedBlocks.clear();
            for (long pos : tag.method_10565("LastDistributedBlocks")) {
                this.lastDistributedBlocks.add(class_2338.method_10092((long)pos));
            }
        }
        this.energyPerTick = tag.method_10537("EnergyPerTick");
        this.distributedBlocksCount = tag.method_10550("DistributedBlocksCount");
        this.limit = tag.method_10550("Limit");
        this.targetGravity = tag.method_10583("TargetGravity");
    }

    @Override
    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        tag.method_10544("EnergyPerTick", this.energyPerTick);
        tag.method_10569("DistributedBlocksCount", this.distributedBlocksCount);
        tag.method_10569("Limit", this.limit);
        tag.method_10548("TargetGravity", this.targetGravity);
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new GravityNormalizerMenu(id, inventory, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachineConfig.deshTierEnergyCapacity, MachineConfig.deshTierMaxEnergyInOut));
        return this.energyContainer;
    }

    @Override
    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        super.serverTick(level, time, state, pos);
        if (this.shutDownTicks > 0) {
            --this.shutDownTicks;
            return;
        }
        boolean canDistribute = this.canCraftDistribution();
        if (this.canFunction() && canDistribute) {
            this.getEnergyStorage().internalExtract(this.calculateEnergyPerTick(), false);
            this.setLit(true);
            if (time % (long)MachineConfig.distributionRefreshRate == 0L) {
                this.tickGravity(level, pos);
            }
            if (time % 200L == 0L) {
                level.method_8396(null, pos, (class_3414)ModSoundEvents.GRAVITY_NORMALIZER_IDLE.get(), class_3419.field_15245, 0.3f, 1.0f);
            }
        } else if (!this.lastDistributedBlocks.isEmpty()) {
            this.clearGravityBlocks();
            this.shutDownTicks = 60;
            this.setLit(false);
        } else if (time % 10L == 0L) {
            this.setLit(false);
        }
        this.energyPerTick = canDistribute ? this.calculateEnergyPerTick() : 0L;
        this.distributedBlocksCount = canDistribute ? this.lastDistributedBlocks.size() : 0;
    }

    @Override
    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pullEnergyNearby(this, pos, this.getEnergyStorage().maxInsert(), sideConfig.get(0), filter);
    }

    @Override
    public void onRemoved() {
        this.clearGravityBlocks();
    }

    private boolean canCraftDistribution() {
        long energy = this.calculateEnergyPerTick();
        return this.getEnergyStorage().internalExtract(energy, true) >= energy;
    }

    protected void tickGravity(class_3218 level, class_2338 pos) {
        this.limit = MachineConfig.maxDistributionBlocks;
        Set<class_2338> positions = FloodFill3D.run((class_1937)level, pos.method_10084(), this.limit, FloodFill3D.TEST_FULL_SEAL, false);
        GravityApi.API.setGravity((class_1937)level, positions, this.targetGravity);
        this.resetLastDistributedBlocks(positions);
    }

    protected void resetLastDistributedBlocks(Set<class_2338> positions) {
        this.lastDistributedBlocks.removeAll(positions);
        this.clearGravityBlocks();
        this.lastDistributedBlocks.addAll(positions);
        this.shouldSyncPositions = true;
    }

    protected void clearGravityBlocks() {
        GravityApi.API.removeGravity(this.field_11863, this.lastDistributedBlocks);
        this.lastDistributedBlocks.clear();
    }

    @Override
    public void clientTick(class_638 level, long time, class_2680 state, class_2338 pos) {
        if (time % 40L == 0L) {
            if (AdAstraConfigClient.showGravityNormalizerArea) {
                AdAstraClient.GRAVITY_OVERLAY_RENDERER.removePositions(pos);
                if (AdAstraClient.GRAVITY_OVERLAY_RENDERER.canAdd(pos) && this.canFunction() && this.canCraftDistribution()) {
                    AdAstraClient.GRAVITY_OVERLAY_RENDERER.addPositions(pos, this.lastDistributedBlocks);
                }
            } else {
                AdAstraClient.GRAVITY_OVERLAY_RENDERER.clearPositions();
            }
        }
        this.lastAnimation = this.animation;
        if (this.isLit()) {
            this.animation += 10.0f;
        }
    }

    public int distributedBlocksCount() {
        return this.canFunction() ? this.distributedBlocksCount : 0;
    }

    public int distributedBlocksLimit() {
        return this.limit;
    }

    public long energyPerTick() {
        return this.canFunction() ? this.energyPerTick : 0L;
    }

    public float targetGravity() {
        return this.targetGravity;
    }

    public void setTargetGravity(float targetGravity) {
        this.targetGravity = targetGravity;
    }

    public float animation() {
        return this.animation;
    }

    public float lastAnimation() {
        return this.lastAnimation;
    }

    private long calculateEnergyPerTick() {
        return Math.max(1, this.lastDistributedBlocks.size() / 24);
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return new int[0];
    }

    @Override
    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        if (this.shouldSyncPositions) {
            tag.method_10564("LastDistributedBlocks", this.lastDistributedBlocks.stream().mapToLong(class_2338::method_10063).toArray());
            this.shouldSyncPositions = false;
        }
        return tag;
    }
}

