/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.theme.Theme;
import snownee.jade.impl.theme.ThemeSerializer;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JadeCodecs;

public class JsonConfig<T> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().enableComplexMapKeySerialization().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(Theme.class, (Object)new ThemeSerializer()).setLenient().create();
    private final File file;
    private final Codec<T> codec;
    private final CachedSupplier<T> configGetter;

    public JsonConfig(String fileName, Codec<T> codec, @Nullable Runnable onUpdate, Supplier<T> defaultFactory) {
        this.file = new File(CommonProxy.getConfigDirectory(), fileName + (fileName.endsWith(".json") ? "" : ".json"));
        this.codec = codec;
        this.configGetter = new CachedSupplier<Object>(() -> {
            Object t;
            if (!this.file.exists()) {
                Object def = defaultFactory.get();
                this.write(def, false);
                return def;
            }
            FileReader reader = new FileReader(this.file, StandardCharsets.UTF_8);
            try {
                t = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson((Reader)reader, JsonElement.class))).get().left().orElseThrow();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    Jade.LOGGER.error("Failed to read config file %s".formatted(this.file), e);
                    if (this.file.length() > 0L) {
                        try {
                            this.file.renameTo(new File(this.file.getPath() + ".invalid"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Object def = defaultFactory.get();
                    this.write(def, false);
                    return def;
                }
            }
            reader.close();
            return t;
        });
        this.configGetter.onUpdate = onUpdate;
    }

    public JsonConfig(String fileName, Codec<T> codec, @Nullable Runnable onUpdate) {
        this(fileName, codec, onUpdate, () -> JadeCodecs.createFromEmptyMap(codec));
        JadeCodecs.createFromEmptyMap(codec);
    }

    public T get() {
        return this.configGetter.get();
    }

    public void save() {
        this.write(this.get(), false);
    }

    public void write(T t, boolean invalidate) {
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(this.file, StandardCharsets.UTF_8);){
            writer.write(GSON.toJson((JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, t).get().left().orElseThrow()));
            if (invalidate) {
                this.invalidate();
            }
        }
        catch (Throwable e) {
            Jade.LOGGER.error("Failed to write config file %s".formatted(this.file), e);
        }
    }

    public void invalidate() {
        this.configGetter.invalidate();
    }

    public File getFile() {
        return this.file;
    }

    static class CachedSupplier<T> {
        private final Supplier<T> supplier;
        private T value;
        private Runnable onUpdate;

        public CachedSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            if (this.value == null) {
                CachedSupplier cachedSupplier = this;
                synchronized (cachedSupplier) {
                    this.value = this.supplier.get();
                    Objects.requireNonNull(this.value);
                    if (this.onUpdate != null) {
                        this.onUpdate.run();
                    }
                }
            }
            return this.value;
        }

        public void invalidate() {
            this.value = null;
        }
    }
}

