/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5348;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import snownee.jade.gui.config.OptionsList;

public abstract class OptionValue<T>
extends OptionsList.Entry {
    private static final class_2561 SERVER_FEATURE = class_2561.method_43470((String)"*").method_27692(class_124.field_1080);
    protected final Consumer<T> setter;
    private final class_2561 title;
    public boolean serverFeature;
    protected T value;
    protected int indent;
    private int x;

    public OptionValue(String optionName, Consumer<T> setter) {
        this.title = OptionValue.makeTitle(optionName);
        this.setter = setter;
        this.addMessage(this.title.getString());
        this.addMessageKey(optionName);
        String key = OptionValue.makeKey(optionName + "_desc");
        if (class_1074.method_4663((String)key)) {
            this.appendDescription(class_1074.method_4662((String)key, (Object[])new Object[0]));
        }
    }

    @Override
    public final void method_25343(class_332 guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        class_339 widget = this.getFirstWidget();
        class_2561 title0 = widget.field_22763 ? this.title : this.title.method_27661().method_27695(new class_124[]{class_124.field_1055, class_124.field_1080});
        int left = rowLeft + this.indent + 10;
        int n = rowTop + height / 2;
        Objects.requireNonNull(this.client.field_1772);
        int top = n - 9 / 2;
        guiGraphics.method_27535(this.client.field_1772, title0, left, top, 0xFFFFFF);
        if (this.serverFeature) {
            guiGraphics.method_27535(this.client.field_1772, SERVER_FEATURE, left + this.getTextWidth() + 1, top, 0xFFFFFF);
        }
        super.method_25343(guiGraphics, index, rowTop, rowLeft, width, height, mouseX, mouseY, hovered, deltaTime);
        this.x = rowLeft;
    }

    public void save() {
        this.setter.accept(this.value);
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public void appendDescription(String description) {
        this.description = this.description == null ? description : this.description + "\n" + description;
        this.addMessage(description);
    }

    public int getX() {
        return this.x;
    }

    @Override
    public int getTextX(int width) {
        return this.getX() + this.indent + 10;
    }

    @Override
    public int getTextWidth() {
        return this.client.field_1772.method_27525((class_5348)this.getTitle());
    }

    public void method_37024(class_6382 output) {
        super.method_37024(output);
        if (!Strings.isNullOrEmpty((String)this.getDescription())) {
            output.method_37034(class_6381.field_33790, (class_2561)class_2561.method_43471((String)this.getDescription()));
        }
    }

    public boolean isValidValue() {
        return true;
    }

    @Override
    public OptionsList.Entry parent(OptionsList.Entry parent) {
        super.parent(parent);
        if (parent instanceof OptionValue) {
            this.indent = ((OptionValue)parent).indent + 12;
        }
        return this;
    }

    public abstract void setValue(T var1);
}

