/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyCallbackToggleBooleanConfigWithMessage;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;

public class ConfigBooleanHotkeyed
extends ConfigBoolean
implements IHotkeyTogglable {
    protected final IKeybind keybind;

    public ConfigBooleanHotkeyed(String name, boolean defaultValue, String defaultHotkey, String comment) {
        this(name, defaultValue, defaultHotkey, comment, StringUtils.splitCamelCase(name));
    }

    public ConfigBooleanHotkeyed(String name, boolean defaultValue, String defaultHotkey, String comment, String prettyName) {
        this(name, defaultValue, defaultHotkey, KeybindSettings.DEFAULT, comment, prettyName);
    }

    public ConfigBooleanHotkeyed(String name, boolean defaultValue, String defaultHotkey, KeybindSettings settings, String comment, String prettyName) {
        super(name, defaultValue, comment, prettyName);
        this.keybind = KeybindMulti.fromStorageString(defaultHotkey, settings);
        this.keybind.setCallback(new KeyCallbackToggleBooleanConfigWithMessage(this));
    }

    @Override
    public IKeybind getKeybind() {
        return this.keybind;
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.getKeybind().isModified();
    }

    @Override
    public void resetToDefault() {
        super.resetToDefault();
        this.keybind.resetToDefault();
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                if (JsonUtils.hasBoolean(obj, "enabled")) {
                    super.setValueFromJsonElement(obj.get("enabled"));
                }
                if (JsonUtils.hasObject(obj, "hotkey")) {
                    JsonObject hotkeyObj = obj.getAsJsonObject("hotkey");
                    this.keybind.setValueFromJsonElement((JsonElement)hotkeyObj);
                }
            } else {
                super.setValueFromJsonElement(element);
            }
        }
        catch (Exception e) {
            MaLiLib.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        JsonObject obj = new JsonObject();
        obj.add("enabled", super.getAsJsonElement());
        obj.add("hotkey", this.getKeybind().getAsJsonElement());
        return obj;
    }
}

