/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.portable_energy_interface;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlock;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlockEntity;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceMovement;
import com.mrh0.createaddition.index.CAPartials;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.function.Consumer;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class PortableEnergyInterfaceRenderer
extends SafeBlockEntityRenderer<PortableEnergyInterfaceBlockEntity> {
    public PortableEnergyInterfaceRenderer(class_5614.class_5615 context) {
    }

    protected void renderSafe(PortableEnergyInterfaceBlockEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (Backend.canUseInstancing((class_1937)te.method_10997())) {
            return;
        }
        class_2680 blockState = te.method_11010();
        float progress = te.getExtensionDistance(partialTicks);
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        PortableEnergyInterfaceRenderer.render(blockState, te.isConnected(), progress, null, sbb -> sbb.light(light).renderInto(ms, vb));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        class_2680 blockState = context.state;
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        float renderPartialTicks = AnimationTickHolder.getPartialTicks();
        LerpedFloat animation = PortableEnergyInterfaceMovement.getAnimation(context);
        float progress = animation.getValue(renderPartialTicks);
        boolean lit = animation.settled();
        PortableEnergyInterfaceRenderer.render(blockState, lit, progress, matrices.getModel(), sbb -> sbb.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight((MovementContext)context, (VirtualRenderWorld)renderWorld)).renderInto(matrices.getViewProjection(), vb));
    }

    private static void render(class_2680 blockState, boolean lit, float progress, class_4587 local, Consumer<SuperByteBuffer> drawCallback) {
        PartialModel middleForState = lit ? CAPartials.PORTABLE_ENERGY_INTERFACE_MIDDLE_POWERED : CAPartials.PORTABLE_ENERGY_INTERFACE_MIDDLE;
        SuperByteBuffer middle = CachedBufferer.partial((PartialModel)middleForState, (class_2680)blockState);
        SuperByteBuffer top = CachedBufferer.partial((PartialModel)CAPartials.PORTABLE_ENERGY_INTERFACE_TOP, (class_2680)blockState);
        if (local != null) {
            middle.transform(local);
            top.transform(local);
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)PortableEnergyInterfaceBlock.field_10927);
        PortableEnergyInterfaceRenderer.rotateToFacing(middle, facing);
        PortableEnergyInterfaceRenderer.rotateToFacing(top, facing);
        middle.translate(0.0, (double)(progress * 0.5f + 0.375f), 0.0);
        top.translate(0.0, (double)progress, 0.0);
        drawCallback.accept(middle);
        drawCallback.accept(top);
    }

    private static void rotateToFacing(SuperByteBuffer buffer, class_2350 facing) {
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)buffer.centre()).rotateY((double)AngleHelper.horizontalAngle((class_2350)facing))).rotateX(facing == class_2350.field_11036 ? 0.0 : (facing == class_2350.field_11033 ? 180.0 : 90.0))).unCentre();
    }

    static PortableEnergyInterfaceBlockEntity getTargetPSI(MovementContext context) {
        String _workingPos_ = "WorkingPos";
        if (!context.data.method_10545(_workingPos_)) {
            return null;
        }
        class_2338 pos = class_2512.method_10691((class_2487)context.data.method_10562(_workingPos_));
        class_2586 tileEntity = context.world.method_8321(pos);
        if (tileEntity instanceof PortableEnergyInterfaceBlockEntity) {
            PortableEnergyInterfaceBlockEntity psi = (PortableEnergyInterfaceBlockEntity)tileEntity;
            return !psi.isTransferring() ? null : psi;
        }
        return null;
    }
}

